// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentProperties;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Role management policy assignment properties with scope. */
@Fluent
public final class RoleManagementPolicyAssignmentProperties {
    /*
     * The role management policy scope.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /*
     * The role definition of management policy assignment.
     */
    @JsonProperty(value = "roleDefinitionId")
    private String roleDefinitionId;

    /*
     * The policy id role management policy assignment.
     */
    @JsonProperty(value = "policyId")
    private String policyId;

    /*
     * The readonly computed rule applied to the policy.
     */
    @JsonProperty(value = "effectiveRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<RoleManagementPolicyRule> effectiveRules;

    /*
     * Additional properties of scope, role definition and policy
     */
    @JsonProperty(value = "policyAssignmentProperties", access = JsonProperty.Access.WRITE_ONLY)
    private PolicyAssignmentProperties policyAssignmentProperties;

    /**
     * Get the scope property: The role management policy scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The role management policy scope.
     *
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinitionId property: The role definition of management policy assignment.
     *
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    /**
     * Set the roleDefinitionId property: The role definition of management policy assignment.
     *
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    /**
     * Get the policyId property: The policy id role management policy assignment.
     *
     * @return the policyId value.
     */
    public String policyId() {
        return this.policyId;
    }

    /**
     * Set the policyId property: The policy id role management policy assignment.
     *
     * @param policyId the policyId value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withPolicyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     *
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    /**
     * Get the policyAssignmentProperties property: Additional properties of scope, role definition and policy.
     *
     * @return the policyAssignmentProperties value.
     */
    public PolicyAssignmentProperties policyAssignmentProperties() {
        return this.policyAssignmentProperties;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (effectiveRules() != null) {
            effectiveRules().forEach(e -> e.validate());
        }
        if (policyAssignmentProperties() != null) {
            policyAssignmentProperties().validate();
        }
    }
}
