// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookTableRow. */
@Fluent
public final class MicrosoftGraphWorkbookTableRow extends MicrosoftGraphEntity {
    /*
     * Returns the index number of the row within the rows collection of the
     * table. Zero-indexed. Read-only.
     */
    @JsonProperty(value = "index")
    private Integer index;

    /*
     * Json
     */
    @JsonProperty(value = "values")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> values;

    /*
     * workbookTableRow
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the index property: Returns the index number of the row within the rows collection of the table.
     * Zero-indexed. Read-only.
     *
     * @return the index value.
     */
    public Integer index() {
        return this.index;
    }

    /**
     * Set the index property: Returns the index number of the row within the rows collection of the table.
     * Zero-indexed. Read-only.
     *
     * @param index the index value to set.
     * @return the MicrosoftGraphWorkbookTableRow object itself.
     */
    public MicrosoftGraphWorkbookTableRow withIndex(Integer index) {
        this.index = index;
        return this;
    }

    /**
     * Get the values property: Json.
     *
     * @return the values value.
     */
    public Map<String, Object> values() {
        return this.values;
    }

    /**
     * Set the values property: Json.
     *
     * @param values the values value to set.
     * @return the MicrosoftGraphWorkbookTableRow object itself.
     */
    public MicrosoftGraphWorkbookTableRow withValues(Map<String, Object> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTableRow.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTableRow.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTableRow object itself.
     */
    public MicrosoftGraphWorkbookTableRow withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookTableRow withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
