// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** workbookTable. */
@Fluent
public final class MicrosoftGraphWorkbookTable extends MicrosoftGraphEntity {
    /*
     * Indicates whether the first column contains special formatting.
     */
    @JsonProperty(value = "highlightFirstColumn")
    private Boolean highlightFirstColumn;

    /*
     * Indicates whether the last column contains special formatting.
     */
    @JsonProperty(value = "highlightLastColumn")
    private Boolean highlightLastColumn;

    /*
     * Legacy Id used in older Excle clients. The value of the identifier
     * remains the same even when the table is renamed. This property should be
     * interpreted as an opaque string value and should not be parsed to any
     * other type. Read-only.
     */
    @JsonProperty(value = "legacyId")
    private String legacyId;

    /*
     * Name of the table.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Indicates whether the columns show banded formatting in which odd
     * columns are highlighted differently from even ones to make reading the
     * table easier.
     */
    @JsonProperty(value = "showBandedColumns")
    private Boolean showBandedColumns;

    /*
     * Indicates whether the rows show banded formatting in which odd rows are
     * highlighted differently from even ones to make reading the table easier.
     */
    @JsonProperty(value = "showBandedRows")
    private Boolean showBandedRows;

    /*
     * Indicates whether the filter buttons are visible at the top of each
     * column header. Setting this is only allowed if the table contains a
     * header row.
     */
    @JsonProperty(value = "showFilterButton")
    private Boolean showFilterButton;

    /*
     * Indicates whether the header row is visible or not. This value can be
     * set to show or remove the header row.
     */
    @JsonProperty(value = "showHeaders")
    private Boolean showHeaders;

    /*
     * Indicates whether the total row is visible or not. This value can be set
     * to show or remove the total row.
     */
    @JsonProperty(value = "showTotals")
    private Boolean showTotals;

    /*
     * Constant value that represents the Table style. The possible values are:
     * TableStyleLight1 thru TableStyleLight21, TableStyleMedium1 thru
     * TableStyleMedium28, TableStyleStyleDark1 thru TableStyleStyleDark11. A
     * custom user-defined style present in the workbook can also be specified.
     */
    @JsonProperty(value = "style")
    private String style;

    /*
     * Represents a collection of all the columns in the table. Read-only.
     */
    @JsonProperty(value = "columns")
    private List<MicrosoftGraphWorkbookTableColumn> columns;

    /*
     * Represents a collection of all the rows in the table. Read-only.
     */
    @JsonProperty(value = "rows")
    private List<MicrosoftGraphWorkbookTableRow> rows;

    /*
     * workbookTableSort
     */
    @JsonProperty(value = "sort")
    private MicrosoftGraphWorkbookTableSort sort;

    /*
     * workbookWorksheet
     */
    @JsonProperty(value = "worksheet")
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookTable
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the highlightFirstColumn property: Indicates whether the first column contains special formatting.
     *
     * @return the highlightFirstColumn value.
     */
    public Boolean highlightFirstColumn() {
        return this.highlightFirstColumn;
    }

    /**
     * Set the highlightFirstColumn property: Indicates whether the first column contains special formatting.
     *
     * @param highlightFirstColumn the highlightFirstColumn value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withHighlightFirstColumn(Boolean highlightFirstColumn) {
        this.highlightFirstColumn = highlightFirstColumn;
        return this;
    }

    /**
     * Get the highlightLastColumn property: Indicates whether the last column contains special formatting.
     *
     * @return the highlightLastColumn value.
     */
    public Boolean highlightLastColumn() {
        return this.highlightLastColumn;
    }

    /**
     * Set the highlightLastColumn property: Indicates whether the last column contains special formatting.
     *
     * @param highlightLastColumn the highlightLastColumn value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withHighlightLastColumn(Boolean highlightLastColumn) {
        this.highlightLastColumn = highlightLastColumn;
        return this;
    }

    /**
     * Get the legacyId property: Legacy Id used in older Excle clients. The value of the identifier remains the same
     * even when the table is renamed. This property should be interpreted as an opaque string value and should not be
     * parsed to any other type. Read-only.
     *
     * @return the legacyId value.
     */
    public String legacyId() {
        return this.legacyId;
    }

    /**
     * Set the legacyId property: Legacy Id used in older Excle clients. The value of the identifier remains the same
     * even when the table is renamed. This property should be interpreted as an opaque string value and should not be
     * parsed to any other type. Read-only.
     *
     * @param legacyId the legacyId value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withLegacyId(String legacyId) {
        this.legacyId = legacyId;
        return this;
    }

    /**
     * Get the name property: Name of the table.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the table.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the showBandedColumns property: Indicates whether the columns show banded formatting in which odd columns are
     * highlighted differently from even ones to make reading the table easier.
     *
     * @return the showBandedColumns value.
     */
    public Boolean showBandedColumns() {
        return this.showBandedColumns;
    }

    /**
     * Set the showBandedColumns property: Indicates whether the columns show banded formatting in which odd columns are
     * highlighted differently from even ones to make reading the table easier.
     *
     * @param showBandedColumns the showBandedColumns value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowBandedColumns(Boolean showBandedColumns) {
        this.showBandedColumns = showBandedColumns;
        return this;
    }

    /**
     * Get the showBandedRows property: Indicates whether the rows show banded formatting in which odd rows are
     * highlighted differently from even ones to make reading the table easier.
     *
     * @return the showBandedRows value.
     */
    public Boolean showBandedRows() {
        return this.showBandedRows;
    }

    /**
     * Set the showBandedRows property: Indicates whether the rows show banded formatting in which odd rows are
     * highlighted differently from even ones to make reading the table easier.
     *
     * @param showBandedRows the showBandedRows value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowBandedRows(Boolean showBandedRows) {
        this.showBandedRows = showBandedRows;
        return this;
    }

    /**
     * Get the showFilterButton property: Indicates whether the filter buttons are visible at the top of each column
     * header. Setting this is only allowed if the table contains a header row.
     *
     * @return the showFilterButton value.
     */
    public Boolean showFilterButton() {
        return this.showFilterButton;
    }

    /**
     * Set the showFilterButton property: Indicates whether the filter buttons are visible at the top of each column
     * header. Setting this is only allowed if the table contains a header row.
     *
     * @param showFilterButton the showFilterButton value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowFilterButton(Boolean showFilterButton) {
        this.showFilterButton = showFilterButton;
        return this;
    }

    /**
     * Get the showHeaders property: Indicates whether the header row is visible or not. This value can be set to show
     * or remove the header row.
     *
     * @return the showHeaders value.
     */
    public Boolean showHeaders() {
        return this.showHeaders;
    }

    /**
     * Set the showHeaders property: Indicates whether the header row is visible or not. This value can be set to show
     * or remove the header row.
     *
     * @param showHeaders the showHeaders value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowHeaders(Boolean showHeaders) {
        this.showHeaders = showHeaders;
        return this;
    }

    /**
     * Get the showTotals property: Indicates whether the total row is visible or not. This value can be set to show or
     * remove the total row.
     *
     * @return the showTotals value.
     */
    public Boolean showTotals() {
        return this.showTotals;
    }

    /**
     * Set the showTotals property: Indicates whether the total row is visible or not. This value can be set to show or
     * remove the total row.
     *
     * @param showTotals the showTotals value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowTotals(Boolean showTotals) {
        this.showTotals = showTotals;
        return this;
    }

    /**
     * Get the style property: Constant value that represents the Table style. The possible values are: TableStyleLight1
     * thru TableStyleLight21, TableStyleMedium1 thru TableStyleMedium28, TableStyleStyleDark1 thru
     * TableStyleStyleDark11. A custom user-defined style present in the workbook can also be specified.
     *
     * @return the style value.
     */
    public String style() {
        return this.style;
    }

    /**
     * Set the style property: Constant value that represents the Table style. The possible values are: TableStyleLight1
     * thru TableStyleLight21, TableStyleMedium1 thru TableStyleMedium28, TableStyleStyleDark1 thru
     * TableStyleStyleDark11. A custom user-defined style present in the workbook can also be specified.
     *
     * @param style the style value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withStyle(String style) {
        this.style = style;
        return this;
    }

    /**
     * Get the columns property: Represents a collection of all the columns in the table. Read-only.
     *
     * @return the columns value.
     */
    public List<MicrosoftGraphWorkbookTableColumn> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Represents a collection of all the columns in the table. Read-only.
     *
     * @param columns the columns value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withColumns(List<MicrosoftGraphWorkbookTableColumn> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the rows property: Represents a collection of all the rows in the table. Read-only.
     *
     * @return the rows value.
     */
    public List<MicrosoftGraphWorkbookTableRow> rows() {
        return this.rows;
    }

    /**
     * Set the rows property: Represents a collection of all the rows in the table. Read-only.
     *
     * @param rows the rows value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withRows(List<MicrosoftGraphWorkbookTableRow> rows) {
        this.rows = rows;
        return this;
    }

    /**
     * Get the sort property: workbookTableSort.
     *
     * @return the sort value.
     */
    public MicrosoftGraphWorkbookTableSort sort() {
        return this.sort;
    }

    /**
     * Set the sort property: workbookTableSort.
     *
     * @param sort the sort value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withSort(MicrosoftGraphWorkbookTableSort sort) {
        this.sort = sort;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     *
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     *
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTable.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTable.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookTable withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (rows() != null) {
            rows().forEach(e -> e.validate());
        }
        if (sort() != null) {
            sort().validate();
        }
        if (worksheet() != null) {
            worksheet().validate();
        }
    }
}
