// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** video. */
@Fluent
public final class MicrosoftGraphVideo {
    /*
     * Number of audio bits per sample.
     */
    @JsonProperty(value = "audioBitsPerSample")
    private Integer audioBitsPerSample;

    /*
     * Number of audio channels.
     */
    @JsonProperty(value = "audioChannels")
    private Integer audioChannels;

    /*
     * Name of the audio format (AAC, MP3, etc.).
     */
    @JsonProperty(value = "audioFormat")
    private String audioFormat;

    /*
     * Number of audio samples per second.
     */
    @JsonProperty(value = "audioSamplesPerSecond")
    private Integer audioSamplesPerSecond;

    /*
     * Bit rate of the video in bits per second.
     */
    @JsonProperty(value = "bitrate")
    private Integer bitrate;

    /*
     * Duration of the file in milliseconds.
     */
    @JsonProperty(value = "duration")
    private Long duration;

    /*
     * 'Four character code' name of the video format.
     */
    @JsonProperty(value = "fourCC")
    private String fourCC;

    /*
     * Frame rate of the video.
     */
    @JsonProperty(value = "frameRate")
    private Double frameRate;

    /*
     * Height of the video, in pixels.
     */
    @JsonProperty(value = "height")
    private Integer height;

    /*
     * Width of the video, in pixels.
     */
    @JsonProperty(value = "width")
    private Integer width;

    /*
     * video
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the audioBitsPerSample property: Number of audio bits per sample.
     *
     * @return the audioBitsPerSample value.
     */
    public Integer audioBitsPerSample() {
        return this.audioBitsPerSample;
    }

    /**
     * Set the audioBitsPerSample property: Number of audio bits per sample.
     *
     * @param audioBitsPerSample the audioBitsPerSample value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioBitsPerSample(Integer audioBitsPerSample) {
        this.audioBitsPerSample = audioBitsPerSample;
        return this;
    }

    /**
     * Get the audioChannels property: Number of audio channels.
     *
     * @return the audioChannels value.
     */
    public Integer audioChannels() {
        return this.audioChannels;
    }

    /**
     * Set the audioChannels property: Number of audio channels.
     *
     * @param audioChannels the audioChannels value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioChannels(Integer audioChannels) {
        this.audioChannels = audioChannels;
        return this;
    }

    /**
     * Get the audioFormat property: Name of the audio format (AAC, MP3, etc.).
     *
     * @return the audioFormat value.
     */
    public String audioFormat() {
        return this.audioFormat;
    }

    /**
     * Set the audioFormat property: Name of the audio format (AAC, MP3, etc.).
     *
     * @param audioFormat the audioFormat value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioFormat(String audioFormat) {
        this.audioFormat = audioFormat;
        return this;
    }

    /**
     * Get the audioSamplesPerSecond property: Number of audio samples per second.
     *
     * @return the audioSamplesPerSecond value.
     */
    public Integer audioSamplesPerSecond() {
        return this.audioSamplesPerSecond;
    }

    /**
     * Set the audioSamplesPerSecond property: Number of audio samples per second.
     *
     * @param audioSamplesPerSecond the audioSamplesPerSecond value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioSamplesPerSecond(Integer audioSamplesPerSecond) {
        this.audioSamplesPerSecond = audioSamplesPerSecond;
        return this;
    }

    /**
     * Get the bitrate property: Bit rate of the video in bits per second.
     *
     * @return the bitrate value.
     */
    public Integer bitrate() {
        return this.bitrate;
    }

    /**
     * Set the bitrate property: Bit rate of the video in bits per second.
     *
     * @param bitrate the bitrate value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withBitrate(Integer bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    /**
     * Get the duration property: Duration of the file in milliseconds.
     *
     * @return the duration value.
     */
    public Long duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of the file in milliseconds.
     *
     * @param duration the duration value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Get the fourCC property: 'Four character code' name of the video format.
     *
     * @return the fourCC value.
     */
    public String fourCC() {
        return this.fourCC;
    }

    /**
     * Set the fourCC property: 'Four character code' name of the video format.
     *
     * @param fourCC the fourCC value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withFourCC(String fourCC) {
        this.fourCC = fourCC;
        return this;
    }

    /**
     * Get the frameRate property: Frame rate of the video.
     *
     * @return the frameRate value.
     */
    public Double frameRate() {
        return this.frameRate;
    }

    /**
     * Set the frameRate property: Frame rate of the video.
     *
     * @param frameRate the frameRate value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withFrameRate(Double frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    /**
     * Get the height property: Height of the video, in pixels.
     *
     * @return the height value.
     */
    public Integer height() {
        return this.height;
    }

    /**
     * Set the height property: Height of the video, in pixels.
     *
     * @param height the height value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Get the width property: Width of the video, in pixels.
     *
     * @return the width value.
     */
    public Integer width() {
        return this.width;
    }

    /**
     * Set the width property: Width of the video, in pixels.
     *
     * @param width the width value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withWidth(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * Get the additionalProperties property: video.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: video.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
