// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** storagePlanInformation. */
@Fluent
public final class MicrosoftGraphStoragePlanInformation {
    /*
     * Indicates whether there are higher storage quota plans available.
     * Read-only.
     */
    @JsonProperty(value = "upgradeAvailable")
    private Boolean upgradeAvailable;

    /*
     * storagePlanInformation
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the upgradeAvailable property: Indicates whether there are higher storage quota plans available. Read-only.
     *
     * @return the upgradeAvailable value.
     */
    public Boolean upgradeAvailable() {
        return this.upgradeAvailable;
    }

    /**
     * Set the upgradeAvailable property: Indicates whether there are higher storage quota plans available. Read-only.
     *
     * @param upgradeAvailable the upgradeAvailable value to set.
     * @return the MicrosoftGraphStoragePlanInformation object itself.
     */
    public MicrosoftGraphStoragePlanInformation withUpgradeAvailable(Boolean upgradeAvailable) {
        this.upgradeAvailable = upgradeAvailable;
        return this;
    }

    /**
     * Get the additionalProperties property: storagePlanInformation.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: storagePlanInformation.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphStoragePlanInformation object itself.
     */
    public MicrosoftGraphStoragePlanInformation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
