// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** shift. */
@Fluent
public final class MicrosoftGraphShift extends MicrosoftGraphChangeTrackedEntity {
    /*
     * shiftItem
     */
    @JsonProperty(value = "draftShift")
    private MicrosoftGraphShiftItem draftShift;

    /*
     * ID of the scheduling group the shift is part of. Required.
     */
    @JsonProperty(value = "schedulingGroupId")
    private String schedulingGroupId;

    /*
     * shiftItem
     */
    @JsonProperty(value = "sharedShift")
    private MicrosoftGraphShiftItem sharedShift;

    /*
     * ID of the user assigned to the shift. Required.
     */
    @JsonProperty(value = "userId")
    private String userId;

    /*
     * shift
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the draftShift property: shiftItem.
     *
     * @return the draftShift value.
     */
    public MicrosoftGraphShiftItem draftShift() {
        return this.draftShift;
    }

    /**
     * Set the draftShift property: shiftItem.
     *
     * @param draftShift the draftShift value to set.
     * @return the MicrosoftGraphShift object itself.
     */
    public MicrosoftGraphShift withDraftShift(MicrosoftGraphShiftItem draftShift) {
        this.draftShift = draftShift;
        return this;
    }

    /**
     * Get the schedulingGroupId property: ID of the scheduling group the shift is part of. Required.
     *
     * @return the schedulingGroupId value.
     */
    public String schedulingGroupId() {
        return this.schedulingGroupId;
    }

    /**
     * Set the schedulingGroupId property: ID of the scheduling group the shift is part of. Required.
     *
     * @param schedulingGroupId the schedulingGroupId value to set.
     * @return the MicrosoftGraphShift object itself.
     */
    public MicrosoftGraphShift withSchedulingGroupId(String schedulingGroupId) {
        this.schedulingGroupId = schedulingGroupId;
        return this;
    }

    /**
     * Get the sharedShift property: shiftItem.
     *
     * @return the sharedShift value.
     */
    public MicrosoftGraphShiftItem sharedShift() {
        return this.sharedShift;
    }

    /**
     * Set the sharedShift property: shiftItem.
     *
     * @param sharedShift the sharedShift value to set.
     * @return the MicrosoftGraphShift object itself.
     */
    public MicrosoftGraphShift withSharedShift(MicrosoftGraphShiftItem sharedShift) {
        this.sharedShift = sharedShift;
        return this;
    }

    /**
     * Get the userId property: ID of the user assigned to the shift. Required.
     *
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: ID of the user assigned to the shift. Required.
     *
     * @param userId the userId value to set.
     * @return the MicrosoftGraphShift object itself.
     */
    public MicrosoftGraphShift withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the additionalProperties property: shift.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: shift.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphShift object itself.
     */
    public MicrosoftGraphShift withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShift withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShift withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShift withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShift withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (draftShift() != null) {
            draftShift().validate();
        }
        if (sharedShift() != null) {
            sharedShift().validate();
        }
    }
}
