// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** settingValue. */
@Fluent
public final class MicrosoftGraphSettingValue {
    /*
     * Name of the setting (as defined by the groupSettingTemplate).
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Value of the setting.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * settingValue
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the name property: Name of the setting (as defined by the groupSettingTemplate).
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the setting (as defined by the groupSettingTemplate).
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphSettingValue object itself.
     */
    public MicrosoftGraphSettingValue withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Value of the setting.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value of the setting.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphSettingValue object itself.
     */
    public MicrosoftGraphSettingValue withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: settingValue.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: settingValue.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSettingValue object itself.
     */
    public MicrosoftGraphSettingValue withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
