// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/** servicePlanInfo. */
@Fluent
public final class MicrosoftGraphServicePlanInfo {
    /*
     * The object the service plan can be assigned to. Possible values:'User' -
     * service plan can be assigned to individual users.'Company' - service
     * plan can be assigned to the entire tenant.
     */
    @JsonProperty(value = "appliesTo")
    private String appliesTo;

    /*
     * The provisioning status of the service plan. Possible values:'Success' -
     * Service is fully provisioned.'Disabled' - Service has been
     * disabled.'PendingInput' - Service is not yet provisioned; awaiting
     * service confirmation.'PendingActivation' - Service is provisioned but
     * requires explicit activation by administrator (for example, Intune_O365
     * service plan)'PendingProvisioning' - Microsoft has added a new service
     * to the product SKU and it has not been activated in the tenant, yet.
     */
    @JsonProperty(value = "provisioningStatus")
    private String provisioningStatus;

    /*
     * The unique identifier of the service plan.
     */
    @JsonProperty(value = "servicePlanId")
    private UUID servicePlanId;

    /*
     * The name of the service plan.
     */
    @JsonProperty(value = "servicePlanName")
    private String servicePlanName;

    /*
     * servicePlanInfo
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the appliesTo property: The object the service plan can be assigned to. Possible values:'User' - service plan
     * can be assigned to individual users.'Company' - service plan can be assigned to the entire tenant.
     *
     * @return the appliesTo value.
     */
    public String appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: The object the service plan can be assigned to. Possible values:'User' - service plan
     * can be assigned to individual users.'Company' - service plan can be assigned to the entire tenant.
     *
     * @param appliesTo the appliesTo value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the provisioningStatus property: The provisioning status of the service plan. Possible values:'Success' -
     * Service is fully provisioned.'Disabled' - Service has been disabled.'PendingInput' - Service is not yet
     * provisioned; awaiting service confirmation.'PendingActivation' - Service is provisioned but requires explicit
     * activation by administrator (for example, Intune_O365 service plan)'PendingProvisioning' - Microsoft has added a
     * new service to the product SKU and it has not been activated in the tenant, yet.
     *
     * @return the provisioningStatus value.
     */
    public String provisioningStatus() {
        return this.provisioningStatus;
    }

    /**
     * Set the provisioningStatus property: The provisioning status of the service plan. Possible values:'Success' -
     * Service is fully provisioned.'Disabled' - Service has been disabled.'PendingInput' - Service is not yet
     * provisioned; awaiting service confirmation.'PendingActivation' - Service is provisioned but requires explicit
     * activation by administrator (for example, Intune_O365 service plan)'PendingProvisioning' - Microsoft has added a
     * new service to the product SKU and it has not been activated in the tenant, yet.
     *
     * @param provisioningStatus the provisioningStatus value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withProvisioningStatus(String provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
        return this;
    }

    /**
     * Get the servicePlanId property: The unique identifier of the service plan.
     *
     * @return the servicePlanId value.
     */
    public UUID servicePlanId() {
        return this.servicePlanId;
    }

    /**
     * Set the servicePlanId property: The unique identifier of the service plan.
     *
     * @param servicePlanId the servicePlanId value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withServicePlanId(UUID servicePlanId) {
        this.servicePlanId = servicePlanId;
        return this;
    }

    /**
     * Get the servicePlanName property: The name of the service plan.
     *
     * @return the servicePlanName value.
     */
    public String servicePlanName() {
        return this.servicePlanName;
    }

    /**
     * Set the servicePlanName property: The name of the service plan.
     *
     * @param servicePlanName the servicePlanName value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withServicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
        return this;
    }

    /**
     * Get the additionalProperties property: servicePlanInfo.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: servicePlanInfo.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
