// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** plannerPlan. */
@Fluent
public final class MicrosoftGraphPlannerPlan extends MicrosoftGraphEntity {
    /*
     * identitySet
     */
    @JsonProperty(value = "createdBy")
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Read-only. Date and time at which the plan is created. The Timestamp
     * type represents date and time information using ISO 8601 format and is
     * always in UTC time. For example, midnight UTC on Jan 1, 2014 would look
     * like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * ID of the Group that owns the plan. A valid group must exist before this
     * field can be set. After it is set, this property can’t be updated.
     */
    @JsonProperty(value = "owner")
    private String owner;

    /*
     * Required. Title of the plan.
     */
    @JsonProperty(value = "title")
    private String title;

    /*
     * Read-only. Nullable. Collection of buckets in the plan.
     */
    @JsonProperty(value = "buckets")
    private List<MicrosoftGraphPlannerBucket> buckets;

    /*
     * plannerPlanDetails
     */
    @JsonProperty(value = "details")
    private MicrosoftGraphPlannerPlanDetails details;

    /*
     * Read-only. Nullable. Collection of tasks in the plan.
     */
    @JsonProperty(value = "tasks")
    private List<MicrosoftGraphPlannerTask> tasks;

    /*
     * plannerPlan
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the createdBy property: identitySet.
     *
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     *
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Read-only. Date and time at which the plan is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Read-only. Date and time at which the plan is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the owner property: ID of the Group that owns the plan. A valid group must exist before this field can be
     * set. After it is set, this property can’t be updated.
     *
     * @return the owner value.
     */
    public String owner() {
        return this.owner;
    }

    /**
     * Set the owner property: ID of the Group that owns the plan. A valid group must exist before this field can be
     * set. After it is set, this property can’t be updated.
     *
     * @param owner the owner value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get the title property: Required. Title of the plan.
     *
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Required. Title of the plan.
     *
     * @param title the title value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the buckets property: Read-only. Nullable. Collection of buckets in the plan.
     *
     * @return the buckets value.
     */
    public List<MicrosoftGraphPlannerBucket> buckets() {
        return this.buckets;
    }

    /**
     * Set the buckets property: Read-only. Nullable. Collection of buckets in the plan.
     *
     * @param buckets the buckets value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withBuckets(List<MicrosoftGraphPlannerBucket> buckets) {
        this.buckets = buckets;
        return this;
    }

    /**
     * Get the details property: plannerPlanDetails.
     *
     * @return the details value.
     */
    public MicrosoftGraphPlannerPlanDetails details() {
        return this.details;
    }

    /**
     * Set the details property: plannerPlanDetails.
     *
     * @param details the details value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withDetails(MicrosoftGraphPlannerPlanDetails details) {
        this.details = details;
        return this;
    }

    /**
     * Get the tasks property: Read-only. Nullable. Collection of tasks in the plan.
     *
     * @return the tasks value.
     */
    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: Read-only. Nullable. Collection of tasks in the plan.
     *
     * @param tasks the tasks value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerPlan.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerPlan.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerPlan withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (buckets() != null) {
            buckets().forEach(e -> e.validate());
        }
        if (details() != null) {
            details().validate();
        }
        if (tasks() != null) {
            tasks().forEach(e -> e.validate());
        }
    }
}
