// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/** permissionScope. */
@Fluent
public final class MicrosoftGraphPermissionScope {
    /*
     * A description of the delegated permissions, intended to be read by an
     * administrator granting the permission on behalf of all users. This text
     * appears in tenant-wide admin consent experiences.
     */
    @JsonProperty(value = "adminConsentDescription")
    private String adminConsentDescription;

    /*
     * The permission's title, intended to be read by an administrator granting
     * the permission on behalf of all users.
     */
    @JsonProperty(value = "adminConsentDisplayName")
    private String adminConsentDisplayName;

    /*
     * Unique delegated permission identifier inside the collection of
     * delegated permissions defined for a resource application.
     */
    @JsonProperty(value = "id")
    private UUID id;

    /*
     * When creating or updating a permission, this property must be set to
     * true (which is the default). To delete a permission, this property must
     * first be set to false.  At that point, in a subsequent call, the
     * permission may be removed.
     */
    @JsonProperty(value = "isEnabled")
    private Boolean isEnabled;

    /*
     * The origin property.
     */
    @JsonProperty(value = "origin")
    private String origin;

    /*
     * Specifies whether this delegated permission should be considered safe
     * for non-admin users to consent to on behalf of themselves, or whether an
     * administrator should be required for consent to the permissions. This
     * will be the default behavior, but each customer can choose to customize
     * the behavior in their organization (by allowing, restricting or limiting
     * user consent to this delegated permission.)
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * A description of the delegated permissions, intended to be read by a
     * user granting the permission on their own behalf. This text appears in
     * consent experiences where the user is consenting only on behalf of
     * themselves.
     */
    @JsonProperty(value = "userConsentDescription")
    private String userConsentDescription;

    /*
     * A title for the permission, intended to be read by a user granting the
     * permission on their own behalf. This text appears in consent experiences
     * where the user is consenting only on behalf of themselves.
     */
    @JsonProperty(value = "userConsentDisplayName")
    private String userConsentDisplayName;

    /*
     * Specifies the value to include in the scp (scope) claim in access
     * tokens. Must not exceed 120 characters in length. Allowed characters are
     * : ! # $ % & ' ( ) * + , - . / : ;  =  ? @ [ ] ^ + _  {  } ~, as well as
     * characters in the ranges 0-9, A-Z and a-z. Any other character,
     * including the space character, are not allowed.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * permissionScope
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the adminConsentDescription property: A description of the delegated permissions, intended to be read by an
     * administrator granting the permission on behalf of all users. This text appears in tenant-wide admin consent
     * experiences.
     *
     * @return the adminConsentDescription value.
     */
    public String adminConsentDescription() {
        return this.adminConsentDescription;
    }

    /**
     * Set the adminConsentDescription property: A description of the delegated permissions, intended to be read by an
     * administrator granting the permission on behalf of all users. This text appears in tenant-wide admin consent
     * experiences.
     *
     * @param adminConsentDescription the adminConsentDescription value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withAdminConsentDescription(String adminConsentDescription) {
        this.adminConsentDescription = adminConsentDescription;
        return this;
    }

    /**
     * Get the adminConsentDisplayName property: The permission's title, intended to be read by an administrator
     * granting the permission on behalf of all users.
     *
     * @return the adminConsentDisplayName value.
     */
    public String adminConsentDisplayName() {
        return this.adminConsentDisplayName;
    }

    /**
     * Set the adminConsentDisplayName property: The permission's title, intended to be read by an administrator
     * granting the permission on behalf of all users.
     *
     * @param adminConsentDisplayName the adminConsentDisplayName value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withAdminConsentDisplayName(String adminConsentDisplayName) {
        this.adminConsentDisplayName = adminConsentDisplayName;
        return this;
    }

    /**
     * Get the id property: Unique delegated permission identifier inside the collection of delegated permissions
     * defined for a resource application.
     *
     * @return the id value.
     */
    public UUID id() {
        return this.id;
    }

    /**
     * Set the id property: Unique delegated permission identifier inside the collection of delegated permissions
     * defined for a resource application.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withId(UUID id) {
        this.id = id;
        return this;
    }

    /**
     * Get the isEnabled property: When creating or updating a permission, this property must be set to true (which is
     * the default). To delete a permission, this property must first be set to false. At that point, in a subsequent
     * call, the permission may be removed.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: When creating or updating a permission, this property must be set to true (which is
     * the default). To delete a permission, this property must first be set to false. At that point, in a subsequent
     * call, the permission may be removed.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the origin property: The origin property.
     *
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Set the origin property: The origin property.
     *
     * @param origin the origin value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    /**
     * Get the type property: Specifies whether this delegated permission should be considered safe for non-admin users
     * to consent to on behalf of themselves, or whether an administrator should be required for consent to the
     * permissions. This will be the default behavior, but each customer can choose to customize the behavior in their
     * organization (by allowing, restricting or limiting user consent to this delegated permission.).
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies whether this delegated permission should be considered safe for non-admin users
     * to consent to on behalf of themselves, or whether an administrator should be required for consent to the
     * permissions. This will be the default behavior, but each customer can choose to customize the behavior in their
     * organization (by allowing, restricting or limiting user consent to this delegated permission.).
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userConsentDescription property: A description of the delegated permissions, intended to be read by a
     * user granting the permission on their own behalf. This text appears in consent experiences where the user is
     * consenting only on behalf of themselves.
     *
     * @return the userConsentDescription value.
     */
    public String userConsentDescription() {
        return this.userConsentDescription;
    }

    /**
     * Set the userConsentDescription property: A description of the delegated permissions, intended to be read by a
     * user granting the permission on their own behalf. This text appears in consent experiences where the user is
     * consenting only on behalf of themselves.
     *
     * @param userConsentDescription the userConsentDescription value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withUserConsentDescription(String userConsentDescription) {
        this.userConsentDescription = userConsentDescription;
        return this;
    }

    /**
     * Get the userConsentDisplayName property: A title for the permission, intended to be read by a user granting the
     * permission on their own behalf. This text appears in consent experiences where the user is consenting only on
     * behalf of themselves.
     *
     * @return the userConsentDisplayName value.
     */
    public String userConsentDisplayName() {
        return this.userConsentDisplayName;
    }

    /**
     * Set the userConsentDisplayName property: A title for the permission, intended to be read by a user granting the
     * permission on their own behalf. This text appears in consent experiences where the user is consenting only on
     * behalf of themselves.
     *
     * @param userConsentDisplayName the userConsentDisplayName value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withUserConsentDisplayName(String userConsentDisplayName) {
        this.userConsentDisplayName = userConsentDisplayName;
        return this;
    }

    /**
     * Get the value property: Specifies the value to include in the scp (scope) claim in access tokens. Must not exceed
     * 120 characters in length. Allowed characters are : ! # $ % &amp; ' ( ) * + , - . / : ; = ? @ [ ] ^ + _ { } ~, as
     * well as characters in the ranges 0-9, A-Z and a-z. Any other character, including the space character, are not
     * allowed.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Specifies the value to include in the scp (scope) claim in access tokens. Must not exceed
     * 120 characters in length. Allowed characters are : ! # $ % &amp; ' ( ) * + , - . / : ; = ? @ [ ] ^ + _ { } ~, as
     * well as characters in the ranges 0-9, A-Z and a-z. Any other character, including the space character, are not
     * allowed.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: permissionScope.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: permissionScope.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPermissionScope object itself.
     */
    public MicrosoftGraphPermissionScope withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
