// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** onenotePatchContentCommand. */
@Fluent
public final class MicrosoftGraphOnenotePatchContentCommand {
    /*
     * onenotePatchActionType
     */
    @JsonProperty(value = "action")
    private MicrosoftGraphOnenotePatchActionType action;

    /*
     * A string of well-formed HTML to add to the page, and any image or file
     * binary data. If the content contains binary data, the request must be
     * sent using the multipart/form-data content type with a 'Commands' part.
     */
    @JsonProperty(value = "content")
    private String content;

    /*
     * onenotePatchInsertPosition
     */
    @JsonProperty(value = "position")
    private MicrosoftGraphOnenotePatchInsertPosition position;

    /*
     * The element to update. Must be the #<data-id> or the generated <id> of
     * the element, or the body or title keyword.
     */
    @JsonProperty(value = "target")
    private String target;

    /*
     * onenotePatchContentCommand
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the action property: onenotePatchActionType.
     *
     * @return the action value.
     */
    public MicrosoftGraphOnenotePatchActionType action() {
        return this.action;
    }

    /**
     * Set the action property: onenotePatchActionType.
     *
     * @param action the action value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withAction(MicrosoftGraphOnenotePatchActionType action) {
        this.action = action;
        return this;
    }

    /**
     * Get the content property: A string of well-formed HTML to add to the page, and any image or file binary data. If
     * the content contains binary data, the request must be sent using the multipart/form-data content type with a
     * 'Commands' part.
     *
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: A string of well-formed HTML to add to the page, and any image or file binary data. If
     * the content contains binary data, the request must be sent using the multipart/form-data content type with a
     * 'Commands' part.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the position property: onenotePatchInsertPosition.
     *
     * @return the position value.
     */
    public MicrosoftGraphOnenotePatchInsertPosition position() {
        return this.position;
    }

    /**
     * Set the position property: onenotePatchInsertPosition.
     *
     * @param position the position value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withPosition(MicrosoftGraphOnenotePatchInsertPosition position) {
        this.position = position;
        return this;
    }

    /**
     * Get the target property: The element to update. Must be the #&lt;data-id&gt; or the generated &lt;id&gt; of the
     * element, or the body or title keyword.
     *
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The element to update. Must be the #&lt;data-id&gt; or the generated &lt;id&gt; of the
     * element, or the body or title keyword.
     *
     * @param target the target value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the additionalProperties property: onenotePatchContentCommand.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenotePatchContentCommand.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
