// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** managedDevice Devices that are managed or pre-enrolled through Intune. */
@Fluent
public final class MicrosoftGraphManagedDevice extends MicrosoftGraphEntity {
    /*
     * Code that allows the Activation Lock on a device to be bypassed.
     */
    @JsonProperty(value = "activationLockBypassCode")
    private String activationLockBypassCode;

    /*
     * Android security patch level
     */
    @JsonProperty(value = "androidSecurityPatchLevel")
    private String androidSecurityPatchLevel;

    /*
     * The unique identifier for the Azure Active Directory device. Read only.
     */
    @JsonProperty(value = "azureADDeviceId")
    private String azureADDeviceId;

    /*
     * Whether the device is Azure Active Directory registered.
     */
    @JsonProperty(value = "azureADRegistered")
    private Boolean azureADRegistered;

    /*
     * The DateTime when device compliance grace period expires
     */
    @JsonProperty(value = "complianceGracePeriodExpirationDateTime")
    private OffsetDateTime complianceGracePeriodExpirationDateTime;

    /*
     * complianceState
     */
    @JsonProperty(value = "complianceState")
    private MicrosoftGraphComplianceState complianceState;

    /*
     * configurationManagerClientEnabledFeatures configuration Manager client
     * enabled features
     */
    @JsonProperty(value = "configurationManagerClientEnabledFeatures")
    private MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;

    /*
     * List of ComplexType deviceActionResult objects.
     */
    @JsonProperty(value = "deviceActionResults")
    private List<MicrosoftGraphDeviceActionResult> deviceActionResults;

    /*
     * Device category display name
     */
    @JsonProperty(value = "deviceCategoryDisplayName")
    private String deviceCategoryDisplayName;

    /*
     * deviceEnrollmentType
     */
    @JsonProperty(value = "deviceEnrollmentType")
    private MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType;

    /*
     * deviceHealthAttestationState
     */
    @JsonProperty(value = "deviceHealthAttestationState")
    private MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState;

    /*
     * Name of the device
     */
    @JsonProperty(value = "deviceName")
    private String deviceName;

    /*
     * deviceRegistrationState
     */
    @JsonProperty(value = "deviceRegistrationState")
    private MicrosoftGraphDeviceRegistrationState deviceRegistrationState;

    /*
     * Whether the device is Exchange ActiveSync activated.
     */
    @JsonProperty(value = "easActivated")
    private Boolean easActivated;

    /*
     * Exchange ActivationSync activation time of the device.
     */
    @JsonProperty(value = "easActivationDateTime")
    private OffsetDateTime easActivationDateTime;

    /*
     * Exchange ActiveSync Id of the device.
     */
    @JsonProperty(value = "easDeviceId")
    private String easDeviceId;

    /*
     * Email(s) for the user associated with the device
     */
    @JsonProperty(value = "emailAddress")
    private String emailAddress;

    /*
     * Enrollment time of the device.
     */
    @JsonProperty(value = "enrolledDateTime")
    private OffsetDateTime enrolledDateTime;

    /*
     * deviceManagementExchangeAccessState
     */
    @JsonProperty(value = "exchangeAccessState")
    private MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState;

    /*
     * deviceManagementExchangeAccessStateReason
     */
    @JsonProperty(value = "exchangeAccessStateReason")
    private MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason;

    /*
     * Last time the device contacted Exchange.
     */
    @JsonProperty(value = "exchangeLastSuccessfulSyncDateTime")
    private OffsetDateTime exchangeLastSuccessfulSyncDateTime;

    /*
     * Free Storage in Bytes
     */
    @JsonProperty(value = "freeStorageSpaceInBytes")
    private Long freeStorageSpaceInBytes;

    /*
     * IMEI
     */
    @JsonProperty(value = "imei")
    private String imei;

    /*
     * Device encryption status
     */
    @JsonProperty(value = "isEncrypted")
    private Boolean isEncrypted;

    /*
     * Device supervised status
     */
    @JsonProperty(value = "isSupervised")
    private Boolean isSupervised;

    /*
     * whether the device is jail broken or rooted.
     */
    @JsonProperty(value = "jailBroken")
    private String jailBroken;

    /*
     * The date and time that the device last completed a successful sync with
     * Intune.
     */
    @JsonProperty(value = "lastSyncDateTime")
    private OffsetDateTime lastSyncDateTime;

    /*
     * Automatically generated name to identify a device. Can be overwritten to
     * a user friendly name.
     */
    @JsonProperty(value = "managedDeviceName")
    private String managedDeviceName;

    /*
     * managedDeviceOwnerType
     */
    @JsonProperty(value = "managedDeviceOwnerType")
    private MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType;

    /*
     * managementAgentType
     */
    @JsonProperty(value = "managementAgent")
    private MicrosoftGraphManagementAgentType managementAgent;

    /*
     * Manufacturer of the device
     */
    @JsonProperty(value = "manufacturer")
    private String manufacturer;

    /*
     * MEID
     */
    @JsonProperty(value = "meid")
    private String meid;

    /*
     * Model of the device
     */
    @JsonProperty(value = "model")
    private String model;

    /*
     * Operating system of the device. Windows, iOS, etc.
     */
    @JsonProperty(value = "operatingSystem")
    private String operatingSystem;

    /*
     * Operating system version of the device.
     */
    @JsonProperty(value = "osVersion")
    private String osVersion;

    /*
     * managedDevicePartnerReportedHealthState
     */
    @JsonProperty(value = "partnerReportedThreatState")
    private MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState;

    /*
     * Phone number of the device
     */
    @JsonProperty(value = "phoneNumber")
    private String phoneNumber;

    /*
     * An error string that identifies issues when creating Remote Assistance
     * session objects.
     */
    @JsonProperty(value = "remoteAssistanceSessionErrorDetails")
    private String remoteAssistanceSessionErrorDetails;

    /*
     * Url that allows a Remote Assistance session to be established with the
     * device.
     */
    @JsonProperty(value = "remoteAssistanceSessionUrl")
    private String remoteAssistanceSessionUrl;

    /*
     * SerialNumber
     */
    @JsonProperty(value = "serialNumber")
    private String serialNumber;

    /*
     * Subscriber Carrier
     */
    @JsonProperty(value = "subscriberCarrier")
    private String subscriberCarrier;

    /*
     * Total Storage in Bytes
     */
    @JsonProperty(value = "totalStorageSpaceInBytes")
    private Long totalStorageSpaceInBytes;

    /*
     * User display name
     */
    @JsonProperty(value = "userDisplayName")
    private String userDisplayName;

    /*
     * Unique Identifier for the user associated with the device
     */
    @JsonProperty(value = "userId")
    private String userId;

    /*
     * Device user principal name
     */
    @JsonProperty(value = "userPrincipalName")
    private String userPrincipalName;

    /*
     * Wi-Fi MAC
     */
    @JsonProperty(value = "wiFiMacAddress")
    private String wiFiMacAddress;

    /*
     * Device compliance policy states for this device.
     */
    @JsonProperty(value = "deviceCompliancePolicyStates")
    private List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates;

    /*
     * Device configuration states for this device.
     */
    @JsonProperty(value = "deviceConfigurationStates")
    private List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates;

    /*
     * deviceCategory Device categories provides a way to organize your
     * devices. Using device categories, company administrators can define
     * their own categories that make sense to their company. These categories
     * can then be applied to a device in the Intune Azure console or selected
     * by a user during device enrollment. You can filter reports and create
     * dynamic Azure Active Directory device groups based on device categories.
     */
    @JsonProperty(value = "deviceCategory")
    private MicrosoftGraphDeviceCategory deviceCategory;

    /*
     * Devices that are managed or pre-enrolled through Intune
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the activationLockBypassCode property: Code that allows the Activation Lock on a device to be bypassed.
     *
     * @return the activationLockBypassCode value.
     */
    public String activationLockBypassCode() {
        return this.activationLockBypassCode;
    }

    /**
     * Set the activationLockBypassCode property: Code that allows the Activation Lock on a device to be bypassed.
     *
     * @param activationLockBypassCode the activationLockBypassCode value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withActivationLockBypassCode(String activationLockBypassCode) {
        this.activationLockBypassCode = activationLockBypassCode;
        return this;
    }

    /**
     * Get the androidSecurityPatchLevel property: Android security patch level.
     *
     * @return the androidSecurityPatchLevel value.
     */
    public String androidSecurityPatchLevel() {
        return this.androidSecurityPatchLevel;
    }

    /**
     * Set the androidSecurityPatchLevel property: Android security patch level.
     *
     * @param androidSecurityPatchLevel the androidSecurityPatchLevel value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withAndroidSecurityPatchLevel(String androidSecurityPatchLevel) {
        this.androidSecurityPatchLevel = androidSecurityPatchLevel;
        return this;
    }

    /**
     * Get the azureADDeviceId property: The unique identifier for the Azure Active Directory device. Read only.
     *
     * @return the azureADDeviceId value.
     */
    public String azureADDeviceId() {
        return this.azureADDeviceId;
    }

    /**
     * Set the azureADDeviceId property: The unique identifier for the Azure Active Directory device. Read only.
     *
     * @param azureADDeviceId the azureADDeviceId value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withAzureADDeviceId(String azureADDeviceId) {
        this.azureADDeviceId = azureADDeviceId;
        return this;
    }

    /**
     * Get the azureADRegistered property: Whether the device is Azure Active Directory registered.
     *
     * @return the azureADRegistered value.
     */
    public Boolean azureADRegistered() {
        return this.azureADRegistered;
    }

    /**
     * Set the azureADRegistered property: Whether the device is Azure Active Directory registered.
     *
     * @param azureADRegistered the azureADRegistered value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withAzureADRegistered(Boolean azureADRegistered) {
        this.azureADRegistered = azureADRegistered;
        return this;
    }

    /**
     * Get the complianceGracePeriodExpirationDateTime property: The DateTime when device compliance grace period
     * expires.
     *
     * @return the complianceGracePeriodExpirationDateTime value.
     */
    public OffsetDateTime complianceGracePeriodExpirationDateTime() {
        return this.complianceGracePeriodExpirationDateTime;
    }

    /**
     * Set the complianceGracePeriodExpirationDateTime property: The DateTime when device compliance grace period
     * expires.
     *
     * @param complianceGracePeriodExpirationDateTime the complianceGracePeriodExpirationDateTime value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withComplianceGracePeriodExpirationDateTime(
        OffsetDateTime complianceGracePeriodExpirationDateTime) {
        this.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        return this;
    }

    /**
     * Get the complianceState property: complianceState.
     *
     * @return the complianceState value.
     */
    public MicrosoftGraphComplianceState complianceState() {
        return this.complianceState;
    }

    /**
     * Set the complianceState property: complianceState.
     *
     * @param complianceState the complianceState value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withComplianceState(MicrosoftGraphComplianceState complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    /**
     * Get the configurationManagerClientEnabledFeatures property: configurationManagerClientEnabledFeatures
     * configuration Manager client enabled features.
     *
     * @return the configurationManagerClientEnabledFeatures value.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures() {
        return this.configurationManagerClientEnabledFeatures;
    }

    /**
     * Set the configurationManagerClientEnabledFeatures property: configurationManagerClientEnabledFeatures
     * configuration Manager client enabled features.
     *
     * @param configurationManagerClientEnabledFeatures the configurationManagerClientEnabledFeatures value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withConfigurationManagerClientEnabledFeatures(
        MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures) {
        this.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
        return this;
    }

    /**
     * Get the deviceActionResults property: List of ComplexType deviceActionResult objects.
     *
     * @return the deviceActionResults value.
     */
    public List<MicrosoftGraphDeviceActionResult> deviceActionResults() {
        return this.deviceActionResults;
    }

    /**
     * Set the deviceActionResults property: List of ComplexType deviceActionResult objects.
     *
     * @param deviceActionResults the deviceActionResults value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceActionResults(
        List<MicrosoftGraphDeviceActionResult> deviceActionResults) {
        this.deviceActionResults = deviceActionResults;
        return this;
    }

    /**
     * Get the deviceCategoryDisplayName property: Device category display name.
     *
     * @return the deviceCategoryDisplayName value.
     */
    public String deviceCategoryDisplayName() {
        return this.deviceCategoryDisplayName;
    }

    /**
     * Set the deviceCategoryDisplayName property: Device category display name.
     *
     * @param deviceCategoryDisplayName the deviceCategoryDisplayName value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceCategoryDisplayName(String deviceCategoryDisplayName) {
        this.deviceCategoryDisplayName = deviceCategoryDisplayName;
        return this;
    }

    /**
     * Get the deviceEnrollmentType property: deviceEnrollmentType.
     *
     * @return the deviceEnrollmentType value.
     */
    public MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType() {
        return this.deviceEnrollmentType;
    }

    /**
     * Set the deviceEnrollmentType property: deviceEnrollmentType.
     *
     * @param deviceEnrollmentType the deviceEnrollmentType value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceEnrollmentType(
        MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType) {
        this.deviceEnrollmentType = deviceEnrollmentType;
        return this;
    }

    /**
     * Get the deviceHealthAttestationState property: deviceHealthAttestationState.
     *
     * @return the deviceHealthAttestationState value.
     */
    public MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState() {
        return this.deviceHealthAttestationState;
    }

    /**
     * Set the deviceHealthAttestationState property: deviceHealthAttestationState.
     *
     * @param deviceHealthAttestationState the deviceHealthAttestationState value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceHealthAttestationState(
        MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState) {
        this.deviceHealthAttestationState = deviceHealthAttestationState;
        return this;
    }

    /**
     * Get the deviceName property: Name of the device.
     *
     * @return the deviceName value.
     */
    public String deviceName() {
        return this.deviceName;
    }

    /**
     * Set the deviceName property: Name of the device.
     *
     * @param deviceName the deviceName value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    /**
     * Get the deviceRegistrationState property: deviceRegistrationState.
     *
     * @return the deviceRegistrationState value.
     */
    public MicrosoftGraphDeviceRegistrationState deviceRegistrationState() {
        return this.deviceRegistrationState;
    }

    /**
     * Set the deviceRegistrationState property: deviceRegistrationState.
     *
     * @param deviceRegistrationState the deviceRegistrationState value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceRegistrationState(
        MicrosoftGraphDeviceRegistrationState deviceRegistrationState) {
        this.deviceRegistrationState = deviceRegistrationState;
        return this;
    }

    /**
     * Get the easActivated property: Whether the device is Exchange ActiveSync activated.
     *
     * @return the easActivated value.
     */
    public Boolean easActivated() {
        return this.easActivated;
    }

    /**
     * Set the easActivated property: Whether the device is Exchange ActiveSync activated.
     *
     * @param easActivated the easActivated value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withEasActivated(Boolean easActivated) {
        this.easActivated = easActivated;
        return this;
    }

    /**
     * Get the easActivationDateTime property: Exchange ActivationSync activation time of the device.
     *
     * @return the easActivationDateTime value.
     */
    public OffsetDateTime easActivationDateTime() {
        return this.easActivationDateTime;
    }

    /**
     * Set the easActivationDateTime property: Exchange ActivationSync activation time of the device.
     *
     * @param easActivationDateTime the easActivationDateTime value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withEasActivationDateTime(OffsetDateTime easActivationDateTime) {
        this.easActivationDateTime = easActivationDateTime;
        return this;
    }

    /**
     * Get the easDeviceId property: Exchange ActiveSync Id of the device.
     *
     * @return the easDeviceId value.
     */
    public String easDeviceId() {
        return this.easDeviceId;
    }

    /**
     * Set the easDeviceId property: Exchange ActiveSync Id of the device.
     *
     * @param easDeviceId the easDeviceId value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withEasDeviceId(String easDeviceId) {
        this.easDeviceId = easDeviceId;
        return this;
    }

    /**
     * Get the emailAddress property: Email(s) for the user associated with the device.
     *
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: Email(s) for the user associated with the device.
     *
     * @param emailAddress the emailAddress value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the enrolledDateTime property: Enrollment time of the device.
     *
     * @return the enrolledDateTime value.
     */
    public OffsetDateTime enrolledDateTime() {
        return this.enrolledDateTime;
    }

    /**
     * Set the enrolledDateTime property: Enrollment time of the device.
     *
     * @param enrolledDateTime the enrolledDateTime value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withEnrolledDateTime(OffsetDateTime enrolledDateTime) {
        this.enrolledDateTime = enrolledDateTime;
        return this;
    }

    /**
     * Get the exchangeAccessState property: deviceManagementExchangeAccessState.
     *
     * @return the exchangeAccessState value.
     */
    public MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState() {
        return this.exchangeAccessState;
    }

    /**
     * Set the exchangeAccessState property: deviceManagementExchangeAccessState.
     *
     * @param exchangeAccessState the exchangeAccessState value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withExchangeAccessState(
        MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState) {
        this.exchangeAccessState = exchangeAccessState;
        return this;
    }

    /**
     * Get the exchangeAccessStateReason property: deviceManagementExchangeAccessStateReason.
     *
     * @return the exchangeAccessStateReason value.
     */
    public MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason() {
        return this.exchangeAccessStateReason;
    }

    /**
     * Set the exchangeAccessStateReason property: deviceManagementExchangeAccessStateReason.
     *
     * @param exchangeAccessStateReason the exchangeAccessStateReason value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withExchangeAccessStateReason(
        MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason) {
        this.exchangeAccessStateReason = exchangeAccessStateReason;
        return this;
    }

    /**
     * Get the exchangeLastSuccessfulSyncDateTime property: Last time the device contacted Exchange.
     *
     * @return the exchangeLastSuccessfulSyncDateTime value.
     */
    public OffsetDateTime exchangeLastSuccessfulSyncDateTime() {
        return this.exchangeLastSuccessfulSyncDateTime;
    }

    /**
     * Set the exchangeLastSuccessfulSyncDateTime property: Last time the device contacted Exchange.
     *
     * @param exchangeLastSuccessfulSyncDateTime the exchangeLastSuccessfulSyncDateTime value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withExchangeLastSuccessfulSyncDateTime(
        OffsetDateTime exchangeLastSuccessfulSyncDateTime) {
        this.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
        return this;
    }

    /**
     * Get the freeStorageSpaceInBytes property: Free Storage in Bytes.
     *
     * @return the freeStorageSpaceInBytes value.
     */
    public Long freeStorageSpaceInBytes() {
        return this.freeStorageSpaceInBytes;
    }

    /**
     * Set the freeStorageSpaceInBytes property: Free Storage in Bytes.
     *
     * @param freeStorageSpaceInBytes the freeStorageSpaceInBytes value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withFreeStorageSpaceInBytes(Long freeStorageSpaceInBytes) {
        this.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
        return this;
    }

    /**
     * Get the imei property: IMEI.
     *
     * @return the imei value.
     */
    public String imei() {
        return this.imei;
    }

    /**
     * Set the imei property: IMEI.
     *
     * @param imei the imei value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withImei(String imei) {
        this.imei = imei;
        return this;
    }

    /**
     * Get the isEncrypted property: Device encryption status.
     *
     * @return the isEncrypted value.
     */
    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    /**
     * Set the isEncrypted property: Device encryption status.
     *
     * @param isEncrypted the isEncrypted value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    /**
     * Get the isSupervised property: Device supervised status.
     *
     * @return the isSupervised value.
     */
    public Boolean isSupervised() {
        return this.isSupervised;
    }

    /**
     * Set the isSupervised property: Device supervised status.
     *
     * @param isSupervised the isSupervised value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withIsSupervised(Boolean isSupervised) {
        this.isSupervised = isSupervised;
        return this;
    }

    /**
     * Get the jailBroken property: whether the device is jail broken or rooted.
     *
     * @return the jailBroken value.
     */
    public String jailBroken() {
        return this.jailBroken;
    }

    /**
     * Set the jailBroken property: whether the device is jail broken or rooted.
     *
     * @param jailBroken the jailBroken value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withJailBroken(String jailBroken) {
        this.jailBroken = jailBroken;
        return this;
    }

    /**
     * Get the lastSyncDateTime property: The date and time that the device last completed a successful sync with
     * Intune.
     *
     * @return the lastSyncDateTime value.
     */
    public OffsetDateTime lastSyncDateTime() {
        return this.lastSyncDateTime;
    }

    /**
     * Set the lastSyncDateTime property: The date and time that the device last completed a successful sync with
     * Intune.
     *
     * @param lastSyncDateTime the lastSyncDateTime value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        this.lastSyncDateTime = lastSyncDateTime;
        return this;
    }

    /**
     * Get the managedDeviceName property: Automatically generated name to identify a device. Can be overwritten to a
     * user friendly name.
     *
     * @return the managedDeviceName value.
     */
    public String managedDeviceName() {
        return this.managedDeviceName;
    }

    /**
     * Set the managedDeviceName property: Automatically generated name to identify a device. Can be overwritten to a
     * user friendly name.
     *
     * @param managedDeviceName the managedDeviceName value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withManagedDeviceName(String managedDeviceName) {
        this.managedDeviceName = managedDeviceName;
        return this;
    }

    /**
     * Get the managedDeviceOwnerType property: managedDeviceOwnerType.
     *
     * @return the managedDeviceOwnerType value.
     */
    public MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType() {
        return this.managedDeviceOwnerType;
    }

    /**
     * Set the managedDeviceOwnerType property: managedDeviceOwnerType.
     *
     * @param managedDeviceOwnerType the managedDeviceOwnerType value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withManagedDeviceOwnerType(
        MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType) {
        this.managedDeviceOwnerType = managedDeviceOwnerType;
        return this;
    }

    /**
     * Get the managementAgent property: managementAgentType.
     *
     * @return the managementAgent value.
     */
    public MicrosoftGraphManagementAgentType managementAgent() {
        return this.managementAgent;
    }

    /**
     * Set the managementAgent property: managementAgentType.
     *
     * @param managementAgent the managementAgent value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withManagementAgent(MicrosoftGraphManagementAgentType managementAgent) {
        this.managementAgent = managementAgent;
        return this;
    }

    /**
     * Get the manufacturer property: Manufacturer of the device.
     *
     * @return the manufacturer value.
     */
    public String manufacturer() {
        return this.manufacturer;
    }

    /**
     * Set the manufacturer property: Manufacturer of the device.
     *
     * @param manufacturer the manufacturer value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    /**
     * Get the meid property: MEID.
     *
     * @return the meid value.
     */
    public String meid() {
        return this.meid;
    }

    /**
     * Set the meid property: MEID.
     *
     * @param meid the meid value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withMeid(String meid) {
        this.meid = meid;
        return this;
    }

    /**
     * Get the model property: Model of the device.
     *
     * @return the model value.
     */
    public String model() {
        return this.model;
    }

    /**
     * Set the model property: Model of the device.
     *
     * @param model the model value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the operatingSystem property: Operating system of the device. Windows, iOS, etc.
     *
     * @return the operatingSystem value.
     */
    public String operatingSystem() {
        return this.operatingSystem;
    }

    /**
     * Set the operatingSystem property: Operating system of the device. Windows, iOS, etc.
     *
     * @param operatingSystem the operatingSystem value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    /**
     * Get the osVersion property: Operating system version of the device.
     *
     * @return the osVersion value.
     */
    public String osVersion() {
        return this.osVersion;
    }

    /**
     * Set the osVersion property: Operating system version of the device.
     *
     * @param osVersion the osVersion value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    /**
     * Get the partnerReportedThreatState property: managedDevicePartnerReportedHealthState.
     *
     * @return the partnerReportedThreatState value.
     */
    public MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState() {
        return this.partnerReportedThreatState;
    }

    /**
     * Set the partnerReportedThreatState property: managedDevicePartnerReportedHealthState.
     *
     * @param partnerReportedThreatState the partnerReportedThreatState value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withPartnerReportedThreatState(
        MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState) {
        this.partnerReportedThreatState = partnerReportedThreatState;
        return this;
    }

    /**
     * Get the phoneNumber property: Phone number of the device.
     *
     * @return the phoneNumber value.
     */
    public String phoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Set the phoneNumber property: Phone number of the device.
     *
     * @param phoneNumber the phoneNumber value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * Get the remoteAssistanceSessionErrorDetails property: An error string that identifies issues when creating Remote
     * Assistance session objects.
     *
     * @return the remoteAssistanceSessionErrorDetails value.
     */
    public String remoteAssistanceSessionErrorDetails() {
        return this.remoteAssistanceSessionErrorDetails;
    }

    /**
     * Set the remoteAssistanceSessionErrorDetails property: An error string that identifies issues when creating Remote
     * Assistance session objects.
     *
     * @param remoteAssistanceSessionErrorDetails the remoteAssistanceSessionErrorDetails value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withRemoteAssistanceSessionErrorDetails(
        String remoteAssistanceSessionErrorDetails) {
        this.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
        return this;
    }

    /**
     * Get the remoteAssistanceSessionUrl property: Url that allows a Remote Assistance session to be established with
     * the device.
     *
     * @return the remoteAssistanceSessionUrl value.
     */
    public String remoteAssistanceSessionUrl() {
        return this.remoteAssistanceSessionUrl;
    }

    /**
     * Set the remoteAssistanceSessionUrl property: Url that allows a Remote Assistance session to be established with
     * the device.
     *
     * @param remoteAssistanceSessionUrl the remoteAssistanceSessionUrl value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withRemoteAssistanceSessionUrl(String remoteAssistanceSessionUrl) {
        this.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
        return this;
    }

    /**
     * Get the serialNumber property: SerialNumber.
     *
     * @return the serialNumber value.
     */
    public String serialNumber() {
        return this.serialNumber;
    }

    /**
     * Set the serialNumber property: SerialNumber.
     *
     * @param serialNumber the serialNumber value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    /**
     * Get the subscriberCarrier property: Subscriber Carrier.
     *
     * @return the subscriberCarrier value.
     */
    public String subscriberCarrier() {
        return this.subscriberCarrier;
    }

    /**
     * Set the subscriberCarrier property: Subscriber Carrier.
     *
     * @param subscriberCarrier the subscriberCarrier value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withSubscriberCarrier(String subscriberCarrier) {
        this.subscriberCarrier = subscriberCarrier;
        return this;
    }

    /**
     * Get the totalStorageSpaceInBytes property: Total Storage in Bytes.
     *
     * @return the totalStorageSpaceInBytes value.
     */
    public Long totalStorageSpaceInBytes() {
        return this.totalStorageSpaceInBytes;
    }

    /**
     * Set the totalStorageSpaceInBytes property: Total Storage in Bytes.
     *
     * @param totalStorageSpaceInBytes the totalStorageSpaceInBytes value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withTotalStorageSpaceInBytes(Long totalStorageSpaceInBytes) {
        this.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
        return this;
    }

    /**
     * Get the userDisplayName property: User display name.
     *
     * @return the userDisplayName value.
     */
    public String userDisplayName() {
        return this.userDisplayName;
    }

    /**
     * Set the userDisplayName property: User display name.
     *
     * @param userDisplayName the userDisplayName value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
        return this;
    }

    /**
     * Get the userId property: Unique Identifier for the user associated with the device.
     *
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: Unique Identifier for the user associated with the device.
     *
     * @param userId the userId value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the userPrincipalName property: Device user principal name.
     *
     * @return the userPrincipalName value.
     */
    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    /**
     * Set the userPrincipalName property: Device user principal name.
     *
     * @param userPrincipalName the userPrincipalName value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    /**
     * Get the wiFiMacAddress property: Wi-Fi MAC.
     *
     * @return the wiFiMacAddress value.
     */
    public String wiFiMacAddress() {
        return this.wiFiMacAddress;
    }

    /**
     * Set the wiFiMacAddress property: Wi-Fi MAC.
     *
     * @param wiFiMacAddress the wiFiMacAddress value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withWiFiMacAddress(String wiFiMacAddress) {
        this.wiFiMacAddress = wiFiMacAddress;
        return this;
    }

    /**
     * Get the deviceCompliancePolicyStates property: Device compliance policy states for this device.
     *
     * @return the deviceCompliancePolicyStates value.
     */
    public List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates() {
        return this.deviceCompliancePolicyStates;
    }

    /**
     * Set the deviceCompliancePolicyStates property: Device compliance policy states for this device.
     *
     * @param deviceCompliancePolicyStates the deviceCompliancePolicyStates value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceCompliancePolicyStates(
        List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates) {
        this.deviceCompliancePolicyStates = deviceCompliancePolicyStates;
        return this;
    }

    /**
     * Get the deviceConfigurationStates property: Device configuration states for this device.
     *
     * @return the deviceConfigurationStates value.
     */
    public List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates() {
        return this.deviceConfigurationStates;
    }

    /**
     * Set the deviceConfigurationStates property: Device configuration states for this device.
     *
     * @param deviceConfigurationStates the deviceConfigurationStates value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceConfigurationStates(
        List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates) {
        this.deviceConfigurationStates = deviceConfigurationStates;
        return this;
    }

    /**
     * Get the deviceCategory property: deviceCategory Device categories provides a way to organize your devices. Using
     * device categories, company administrators can define their own categories that make sense to their company. These
     * categories can then be applied to a device in the Intune Azure console or selected by a user during device
     * enrollment. You can filter reports and create dynamic Azure Active Directory device groups based on device
     * categories.
     *
     * @return the deviceCategory value.
     */
    public MicrosoftGraphDeviceCategory deviceCategory() {
        return this.deviceCategory;
    }

    /**
     * Set the deviceCategory property: deviceCategory Device categories provides a way to organize your devices. Using
     * device categories, company administrators can define their own categories that make sense to their company. These
     * categories can then be applied to a device in the Intune Azure console or selected by a user during device
     * enrollment. You can filter reports and create dynamic Azure Active Directory device groups based on device
     * categories.
     *
     * @param deviceCategory the deviceCategory value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withDeviceCategory(MicrosoftGraphDeviceCategory deviceCategory) {
        this.deviceCategory = deviceCategory;
        return this;
    }

    /**
     * Get the additionalProperties property: Devices that are managed or pre-enrolled through Intune.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Devices that are managed or pre-enrolled through Intune.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphManagedDevice object itself.
     */
    public MicrosoftGraphManagedDevice withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphManagedDevice withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (configurationManagerClientEnabledFeatures() != null) {
            configurationManagerClientEnabledFeatures().validate();
        }
        if (deviceActionResults() != null) {
            deviceActionResults().forEach(e -> e.validate());
        }
        if (deviceHealthAttestationState() != null) {
            deviceHealthAttestationState().validate();
        }
        if (deviceCompliancePolicyStates() != null) {
            deviceCompliancePolicyStates().forEach(e -> e.validate());
        }
        if (deviceConfigurationStates() != null) {
            deviceConfigurationStates().forEach(e -> e.validate());
        }
        if (deviceCategory() != null) {
            deviceCategory().validate();
        }
    }
}
