// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** mailFolder. */
@Fluent
public final class MicrosoftGraphMailFolder extends MicrosoftGraphEntity {
    /*
     * The number of immediate child mailFolders in the current mailFolder.
     */
    @JsonProperty(value = "childFolderCount")
    private Integer childFolderCount;

    /*
     * The mailFolder's display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The unique identifier for the mailFolder's parent mailFolder.
     */
    @JsonProperty(value = "parentFolderId")
    private String parentFolderId;

    /*
     * The number of items in the mailFolder.
     */
    @JsonProperty(value = "totalItemCount")
    private Integer totalItemCount;

    /*
     * The number of items in the mailFolder marked as unread.
     */
    @JsonProperty(value = "unreadItemCount")
    private Integer unreadItemCount;

    /*
     * The collection of child folders in the mailFolder.
     */
    @JsonProperty(value = "childFolders")
    private List<MicrosoftGraphMailFolder> childFolders;

    /*
     * The collection of rules that apply to the user's Inbox folder.
     */
    @JsonProperty(value = "messageRules")
    private List<MicrosoftGraphMessageRule> messageRules;

    /*
     * The collection of messages in the mailFolder.
     */
    @JsonProperty(value = "messages")
    private List<MicrosoftGraphMessage> messages;

    /*
     * The collection of multi-value extended properties defined for the
     * mailFolder. Read-only. Nullable.
     */
    @JsonProperty(value = "multiValueExtendedProperties")
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the
     * mailFolder. Read-only. Nullable.
     */
    @JsonProperty(value = "singleValueExtendedProperties")
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * mailFolder
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the childFolderCount property: The number of immediate child mailFolders in the current mailFolder.
     *
     * @return the childFolderCount value.
     */
    public Integer childFolderCount() {
        return this.childFolderCount;
    }

    /**
     * Set the childFolderCount property: The number of immediate child mailFolders in the current mailFolder.
     *
     * @param childFolderCount the childFolderCount value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withChildFolderCount(Integer childFolderCount) {
        this.childFolderCount = childFolderCount;
        return this;
    }

    /**
     * Get the displayName property: The mailFolder's display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The mailFolder's display name.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the parentFolderId property: The unique identifier for the mailFolder's parent mailFolder.
     *
     * @return the parentFolderId value.
     */
    public String parentFolderId() {
        return this.parentFolderId;
    }

    /**
     * Set the parentFolderId property: The unique identifier for the mailFolder's parent mailFolder.
     *
     * @param parentFolderId the parentFolderId value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Get the totalItemCount property: The number of items in the mailFolder.
     *
     * @return the totalItemCount value.
     */
    public Integer totalItemCount() {
        return this.totalItemCount;
    }

    /**
     * Set the totalItemCount property: The number of items in the mailFolder.
     *
     * @param totalItemCount the totalItemCount value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withTotalItemCount(Integer totalItemCount) {
        this.totalItemCount = totalItemCount;
        return this;
    }

    /**
     * Get the unreadItemCount property: The number of items in the mailFolder marked as unread.
     *
     * @return the unreadItemCount value.
     */
    public Integer unreadItemCount() {
        return this.unreadItemCount;
    }

    /**
     * Set the unreadItemCount property: The number of items in the mailFolder marked as unread.
     *
     * @param unreadItemCount the unreadItemCount value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withUnreadItemCount(Integer unreadItemCount) {
        this.unreadItemCount = unreadItemCount;
        return this;
    }

    /**
     * Get the childFolders property: The collection of child folders in the mailFolder.
     *
     * @return the childFolders value.
     */
    public List<MicrosoftGraphMailFolder> childFolders() {
        return this.childFolders;
    }

    /**
     * Set the childFolders property: The collection of child folders in the mailFolder.
     *
     * @param childFolders the childFolders value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withChildFolders(List<MicrosoftGraphMailFolder> childFolders) {
        this.childFolders = childFolders;
        return this;
    }

    /**
     * Get the messageRules property: The collection of rules that apply to the user's Inbox folder.
     *
     * @return the messageRules value.
     */
    public List<MicrosoftGraphMessageRule> messageRules() {
        return this.messageRules;
    }

    /**
     * Set the messageRules property: The collection of rules that apply to the user's Inbox folder.
     *
     * @param messageRules the messageRules value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withMessageRules(List<MicrosoftGraphMessageRule> messageRules) {
        this.messageRules = messageRules;
        return this;
    }

    /**
     * Get the messages property: The collection of messages in the mailFolder.
     *
     * @return the messages value.
     */
    public List<MicrosoftGraphMessage> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: The collection of messages in the mailFolder.
     *
     * @param messages the messages value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withMessages(List<MicrosoftGraphMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * mailFolder. Read-only. Nullable.
     *
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * mailFolder. Read-only. Nullable.
     *
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the mailFolder. Read-only. Nullable.
     *
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the mailFolder. Read-only. Nullable.
     *
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: mailFolder.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: mailFolder.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMailFolder object itself.
     */
    public MicrosoftGraphMailFolder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMailFolder withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (childFolders() != null) {
            childFolders().forEach(e -> e.validate());
        }
        if (messageRules() != null) {
            messageRules().forEach(e -> e.validate());
        }
        if (messages() != null) {
            messages().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }
}
