// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** listItem. */
@Fluent
public final class MicrosoftGraphListItem extends MicrosoftGraphBaseItemInner {
    /*
     * contentTypeInfo
     */
    @JsonProperty(value = "contentType")
    private MicrosoftGraphContentTypeInfo contentType;

    /*
     * sharepointIds
     */
    @JsonProperty(value = "sharepointIds")
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * itemAnalytics
     */
    @JsonProperty(value = "analytics")
    private MicrosoftGraphItemAnalytics analytics;

    /*
     * driveItem
     */
    @JsonProperty(value = "driveItem")
    private MicrosoftGraphDriveItem driveItem;

    /*
     * fieldValueSet
     */
    @JsonProperty(value = "fields")
    private MicrosoftGraphFieldValueSet fields;

    /*
     * The list of previous versions of the list item.
     */
    @JsonProperty(value = "versions")
    private List<MicrosoftGraphListItemVersion> versions;

    /*
     * listItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the contentType property: contentTypeInfo.
     *
     * @return the contentType value.
     */
    public MicrosoftGraphContentTypeInfo contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: contentTypeInfo.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withContentType(MicrosoftGraphContentTypeInfo contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     *
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     *
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the analytics property: itemAnalytics.
     *
     * @return the analytics value.
     */
    public MicrosoftGraphItemAnalytics analytics() {
        return this.analytics;
    }

    /**
     * Set the analytics property: itemAnalytics.
     *
     * @param analytics the analytics value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withAnalytics(MicrosoftGraphItemAnalytics analytics) {
        this.analytics = analytics;
        return this;
    }

    /**
     * Get the driveItem property: driveItem.
     *
     * @return the driveItem value.
     */
    public MicrosoftGraphDriveItem driveItem() {
        return this.driveItem;
    }

    /**
     * Set the driveItem property: driveItem.
     *
     * @param driveItem the driveItem value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withDriveItem(MicrosoftGraphDriveItem driveItem) {
        this.driveItem = driveItem;
        return this;
    }

    /**
     * Get the fields property: fieldValueSet.
     *
     * @return the fields value.
     */
    public MicrosoftGraphFieldValueSet fields() {
        return this.fields;
    }

    /**
     * Set the fields property: fieldValueSet.
     *
     * @param fields the fields value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withFields(MicrosoftGraphFieldValueSet fields) {
        this.fields = fields;
        return this;
    }

    /**
     * Get the versions property: The list of previous versions of the list item.
     *
     * @return the versions value.
     */
    public List<MicrosoftGraphListItemVersion> versions() {
        return this.versions;
    }

    /**
     * Set the versions property: The list of previous versions of the list item.
     *
     * @param versions the versions value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withVersions(List<MicrosoftGraphListItemVersion> versions) {
        this.versions = versions;
        return this;
    }

    /**
     * Get the additionalProperties property: listItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: listItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphListItem object itself.
     */
    public MicrosoftGraphListItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withName(String name) {
        super.withName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItem withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (contentType() != null) {
            contentType().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (analytics() != null) {
            analytics().validate();
        }
        if (driveItem() != null) {
            driveItem().validate();
        }
        if (fields() != null) {
            fields().validate();
        }
        if (versions() != null) {
            versions().forEach(e -> e.validate());
        }
    }
}
