// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** itemActivityStat. */
@Fluent
public final class MicrosoftGraphItemActivityStat extends MicrosoftGraphEntity {
    /*
     * itemActionStat
     */
    @JsonProperty(value = "access")
    private MicrosoftGraphItemActionStat access;

    /*
     * itemActionStat
     */
    @JsonProperty(value = "create")
    private MicrosoftGraphItemActionStat create;

    /*
     * itemActionStat
     */
    @JsonProperty(value = "delete")
    private MicrosoftGraphItemActionStat delete;

    /*
     * itemActionStat
     */
    @JsonProperty(value = "edit")
    private MicrosoftGraphItemActionStat edit;

    /*
     * When the interval ends. Read-only.
     */
    @JsonProperty(value = "endDateTime")
    private OffsetDateTime endDateTime;

    /*
     * incompleteData
     */
    @JsonProperty(value = "incompleteData")
    private MicrosoftGraphIncompleteData incompleteData;

    /*
     * Indicates whether the item is 'trending.' Read-only.
     */
    @JsonProperty(value = "isTrending")
    private Boolean isTrending;

    /*
     * itemActionStat
     */
    @JsonProperty(value = "move")
    private MicrosoftGraphItemActionStat move;

    /*
     * When the interval starts. Read-only.
     */
    @JsonProperty(value = "startDateTime")
    private OffsetDateTime startDateTime;

    /*
     * Exposes the itemActivities represented in this itemActivityStat
     * resource.
     */
    @JsonProperty(value = "activities")
    private List<MicrosoftGraphItemActivity> activities;

    /*
     * itemActivityStat
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the access property: itemActionStat.
     *
     * @return the access value.
     */
    public MicrosoftGraphItemActionStat access() {
        return this.access;
    }

    /**
     * Set the access property: itemActionStat.
     *
     * @param access the access value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withAccess(MicrosoftGraphItemActionStat access) {
        this.access = access;
        return this;
    }

    /**
     * Get the create property: itemActionStat.
     *
     * @return the create value.
     */
    public MicrosoftGraphItemActionStat create() {
        return this.create;
    }

    /**
     * Set the create property: itemActionStat.
     *
     * @param create the create value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withCreate(MicrosoftGraphItemActionStat create) {
        this.create = create;
        return this;
    }

    /**
     * Get the delete property: itemActionStat.
     *
     * @return the delete value.
     */
    public MicrosoftGraphItemActionStat delete() {
        return this.delete;
    }

    /**
     * Set the delete property: itemActionStat.
     *
     * @param delete the delete value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withDelete(MicrosoftGraphItemActionStat delete) {
        this.delete = delete;
        return this;
    }

    /**
     * Get the edit property: itemActionStat.
     *
     * @return the edit value.
     */
    public MicrosoftGraphItemActionStat edit() {
        return this.edit;
    }

    /**
     * Set the edit property: itemActionStat.
     *
     * @param edit the edit value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withEdit(MicrosoftGraphItemActionStat edit) {
        this.edit = edit;
        return this;
    }

    /**
     * Get the endDateTime property: When the interval ends. Read-only.
     *
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: When the interval ends. Read-only.
     *
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the incompleteData property: incompleteData.
     *
     * @return the incompleteData value.
     */
    public MicrosoftGraphIncompleteData incompleteData() {
        return this.incompleteData;
    }

    /**
     * Set the incompleteData property: incompleteData.
     *
     * @param incompleteData the incompleteData value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withIncompleteData(MicrosoftGraphIncompleteData incompleteData) {
        this.incompleteData = incompleteData;
        return this;
    }

    /**
     * Get the isTrending property: Indicates whether the item is 'trending.' Read-only.
     *
     * @return the isTrending value.
     */
    public Boolean isTrending() {
        return this.isTrending;
    }

    /**
     * Set the isTrending property: Indicates whether the item is 'trending.' Read-only.
     *
     * @param isTrending the isTrending value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withIsTrending(Boolean isTrending) {
        this.isTrending = isTrending;
        return this;
    }

    /**
     * Get the move property: itemActionStat.
     *
     * @return the move value.
     */
    public MicrosoftGraphItemActionStat move() {
        return this.move;
    }

    /**
     * Set the move property: itemActionStat.
     *
     * @param move the move value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withMove(MicrosoftGraphItemActionStat move) {
        this.move = move;
        return this;
    }

    /**
     * Get the startDateTime property: When the interval starts. Read-only.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: When the interval starts. Read-only.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the activities property: Exposes the itemActivities represented in this itemActivityStat resource.
     *
     * @return the activities value.
     */
    public List<MicrosoftGraphItemActivity> activities() {
        return this.activities;
    }

    /**
     * Set the activities property: Exposes the itemActivities represented in this itemActivityStat resource.
     *
     * @param activities the activities value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withActivities(List<MicrosoftGraphItemActivity> activities) {
        this.activities = activities;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActivityStat.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActivityStat.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphItemActivityStat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (access() != null) {
            access().validate();
        }
        if (create() != null) {
            create().validate();
        }
        if (delete() != null) {
            delete().validate();
        }
        if (edit() != null) {
            edit().validate();
        }
        if (incompleteData() != null) {
            incompleteData().validate();
        }
        if (move() != null) {
            move().validate();
        }
        if (activities() != null) {
            activities().forEach(e -> e.validate());
        }
    }
}
