// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** itemActionStat. */
@Fluent
public final class MicrosoftGraphItemActionStat {
    /*
     * The number of times the action took place. Read-only.
     */
    @JsonProperty(value = "actionCount")
    private Integer actionCount;

    /*
     * The number of distinct actors that performed the action. Read-only.
     */
    @JsonProperty(value = "actorCount")
    private Integer actorCount;

    /*
     * itemActionStat
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the actionCount property: The number of times the action took place. Read-only.
     *
     * @return the actionCount value.
     */
    public Integer actionCount() {
        return this.actionCount;
    }

    /**
     * Set the actionCount property: The number of times the action took place. Read-only.
     *
     * @param actionCount the actionCount value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withActionCount(Integer actionCount) {
        this.actionCount = actionCount;
        return this;
    }

    /**
     * Get the actorCount property: The number of distinct actors that performed the action. Read-only.
     *
     * @return the actorCount value.
     */
    public Integer actorCount() {
        return this.actorCount;
    }

    /**
     * Set the actorCount property: The number of distinct actors that performed the action. Read-only.
     *
     * @param actorCount the actorCount value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withActorCount(Integer actorCount) {
        this.actorCount = actorCount;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActionStat.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActionStat.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
