// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** hashes. */
@Fluent
public final class MicrosoftGraphHashes {
    /*
     * The CRC32 value of the file in little endian (if available). Read-only.
     */
    @JsonProperty(value = "crc32Hash")
    private String crc32Hash;

    /*
     * A proprietary hash of the file that can be used to determine if the
     * contents of the file have changed (if available). Read-only.
     */
    @JsonProperty(value = "quickXorHash")
    private String quickXorHash;

    /*
     * SHA1 hash for the contents of the file (if available). Read-only.
     */
    @JsonProperty(value = "sha1Hash")
    private String sha1Hash;

    /*
     * SHA256 hash for the contents of the file (if available). Read-only.
     */
    @JsonProperty(value = "sha256Hash")
    private String sha256Hash;

    /*
     * hashes
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the crc32Hash property: The CRC32 value of the file in little endian (if available). Read-only.
     *
     * @return the crc32Hash value.
     */
    public String crc32Hash() {
        return this.crc32Hash;
    }

    /**
     * Set the crc32Hash property: The CRC32 value of the file in little endian (if available). Read-only.
     *
     * @param crc32Hash the crc32Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withCrc32Hash(String crc32Hash) {
        this.crc32Hash = crc32Hash;
        return this;
    }

    /**
     * Get the quickXorHash property: A proprietary hash of the file that can be used to determine if the contents of
     * the file have changed (if available). Read-only.
     *
     * @return the quickXorHash value.
     */
    public String quickXorHash() {
        return this.quickXorHash;
    }

    /**
     * Set the quickXorHash property: A proprietary hash of the file that can be used to determine if the contents of
     * the file have changed (if available). Read-only.
     *
     * @param quickXorHash the quickXorHash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withQuickXorHash(String quickXorHash) {
        this.quickXorHash = quickXorHash;
        return this;
    }

    /**
     * Get the sha1Hash property: SHA1 hash for the contents of the file (if available). Read-only.
     *
     * @return the sha1Hash value.
     */
    public String sha1Hash() {
        return this.sha1Hash;
    }

    /**
     * Set the sha1Hash property: SHA1 hash for the contents of the file (if available). Read-only.
     *
     * @param sha1Hash the sha1Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withSha1Hash(String sha1Hash) {
        this.sha1Hash = sha1Hash;
        return this;
    }

    /**
     * Get the sha256Hash property: SHA256 hash for the contents of the file (if available). Read-only.
     *
     * @return the sha256Hash value.
     */
    public String sha256Hash() {
        return this.sha256Hash;
    }

    /**
     * Set the sha256Hash property: SHA256 hash for the contents of the file (if available). Read-only.
     *
     * @param sha256Hash the sha256Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withSha256Hash(String sha256Hash) {
        this.sha256Hash = sha256Hash;
        return this;
    }

    /**
     * Get the additionalProperties property: hashes.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: hashes.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
