// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * device Represents an Azure Active Directory object. The directoryObject type is the base type for many other
 * directory entity types.
 */
@Fluent
public final class MicrosoftGraphDevice extends MicrosoftGraphDirectoryObjectInner {
    /*
     * true if the account is enabled; otherwise, false. Required.
     */
    @JsonProperty(value = "accountEnabled")
    private Boolean accountEnabled;

    /*
     * For internal use only. Not nullable.
     */
    @JsonProperty(value = "alternativeSecurityIds")
    private List<MicrosoftGraphAlternativeSecurityId> alternativeSecurityIds;

    /*
     * The timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     */
    @JsonProperty(value = "approximateLastSignInDateTime")
    private OffsetDateTime approximateLastSignInDateTime;

    /*
     * The timestamp when the device is no longer deemed compliant. The
     * timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     */
    @JsonProperty(value = "complianceExpirationDateTime")
    private OffsetDateTime complianceExpirationDateTime;

    /*
     * Unique identifier set by Azure Device Registration Service at the time
     * of registration.
     */
    @JsonProperty(value = "deviceId")
    private String deviceId;

    /*
     * For internal use only. Set to null.
     */
    @JsonProperty(value = "deviceMetadata")
    private String deviceMetadata;

    /*
     * For internal use only.
     */
    @JsonProperty(value = "deviceVersion")
    private Integer deviceVersion;

    /*
     * The display name for the device. Required.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * true if the device complies with Mobile Device Management (MDM)
     * policies; otherwise, false. Read-only. This can only be updated by
     * Intune for any device OS type or by an approved MDM app for Windows OS
     * devices.
     */
    @JsonProperty(value = "isCompliant")
    private Boolean isCompliant;

    /*
     * true if the device is managed by a Mobile Device Management (MDM) app;
     * otherwise, false. This can only be updated by Intune for any device OS
     * type or by an approved MDM app for Windows OS devices.
     */
    @JsonProperty(value = "isManaged")
    private Boolean isManaged;

    /*
     * Application identifier used to register device into MDM. Read-only.
     * Supports $filter.
     */
    @JsonProperty(value = "mdmAppId")
    private String mdmAppId;

    /*
     * The last time at which the object was synced with the on-premises
     * directory. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on
     * Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z' Read-only.
     */
    @JsonProperty(value = "onPremisesLastSyncDateTime")
    private OffsetDateTime onPremisesLastSyncDateTime;

    /*
     * true if this object is synced from an on-premises directory; false if
     * this object was originally synced from an on-premises directory but is
     * no longer synced; null if this object has never been synced from an
     * on-premises directory (default). Read-only.
     */
    @JsonProperty(value = "onPremisesSyncEnabled")
    private Boolean onPremisesSyncEnabled;

    /*
     * The type of operating system on the device. Required.
     */
    @JsonProperty(value = "operatingSystem")
    private String operatingSystem;

    /*
     * The version of the operating system on the device. Required.
     */
    @JsonProperty(value = "operatingSystemVersion")
    private String operatingSystemVersion;

    /*
     * For internal use only. Not nullable.
     */
    @JsonProperty(value = "physicalIds")
    private List<String> physicalIds;

    /*
     * The profile type of the device. Possible values:RegisteredDevice
     * (default)SecureVMPrinterSharedIoT
     */
    @JsonProperty(value = "profileType")
    private String profileType;

    /*
     * List of labels applied to the device by the system.
     */
    @JsonProperty(value = "systemLabels")
    private List<String> systemLabels;

    /*
     * Type of trust for the joined device. Read-only. Possible values:
     * Workplace - indicates bring your own personal devicesAzureAd - Cloud
     * only joined devicesServerAd - on-premises domain joined devices joined
     * to Azure AD. For more details, see Introduction to device management in
     * Azure Active Directory
     */
    @JsonProperty(value = "trustType")
    private String trustType;

    /*
     * Groups that this group is a member of. HTTP Methods: GET (supported for
     * all groups). Read-only. Nullable.
     */
    @JsonProperty(value = "memberOf")
    private List<MicrosoftGraphDirectoryObjectInner> memberOf;

    /*
     * The user that cloud joined the device or registered their personal
     * device. The registered owner is set at the time of registration.
     * Currently, there can be only one owner. Read-only. Nullable.
     */
    @JsonProperty(value = "registeredOwners")
    private List<MicrosoftGraphDirectoryObjectInner> registeredOwners;

    /*
     * Collection of registered users of the device. For cloud joined devices
     * and registered personal devices, registered users are set to the same
     * value as registered owners at the time of registration. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "registeredUsers")
    private List<MicrosoftGraphDirectoryObjectInner> registeredUsers;

    /*
     * The transitiveMemberOf property.
     */
    @JsonProperty(value = "transitiveMemberOf")
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf;

    /*
     * The collection of open extensions defined for the device. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtension> extensions;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the accountEnabled property: true if the account is enabled; otherwise, false. Required.
     *
     * @return the accountEnabled value.
     */
    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    /**
     * Set the accountEnabled property: true if the account is enabled; otherwise, false. Required.
     *
     * @param accountEnabled the accountEnabled value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    /**
     * Get the alternativeSecurityIds property: For internal use only. Not nullable.
     *
     * @return the alternativeSecurityIds value.
     */
    public List<MicrosoftGraphAlternativeSecurityId> alternativeSecurityIds() {
        return this.alternativeSecurityIds;
    }

    /**
     * Set the alternativeSecurityIds property: For internal use only. Not nullable.
     *
     * @param alternativeSecurityIds the alternativeSecurityIds value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withAlternativeSecurityIds(
        List<MicrosoftGraphAlternativeSecurityId> alternativeSecurityIds) {
        this.alternativeSecurityIds = alternativeSecurityIds;
        return this;
    }

    /**
     * Get the approximateLastSignInDateTime property: The timestamp type represents date and time information using ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Read-only.
     *
     * @return the approximateLastSignInDateTime value.
     */
    public OffsetDateTime approximateLastSignInDateTime() {
        return this.approximateLastSignInDateTime;
    }

    /**
     * Set the approximateLastSignInDateTime property: The timestamp type represents date and time information using ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Read-only.
     *
     * @param approximateLastSignInDateTime the approximateLastSignInDateTime value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withApproximateLastSignInDateTime(OffsetDateTime approximateLastSignInDateTime) {
        this.approximateLastSignInDateTime = approximateLastSignInDateTime;
        return this;
    }

    /**
     * Get the complianceExpirationDateTime property: The timestamp when the device is no longer deemed compliant. The
     * timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     *
     * @return the complianceExpirationDateTime value.
     */
    public OffsetDateTime complianceExpirationDateTime() {
        return this.complianceExpirationDateTime;
    }

    /**
     * Set the complianceExpirationDateTime property: The timestamp when the device is no longer deemed compliant. The
     * timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     *
     * @param complianceExpirationDateTime the complianceExpirationDateTime value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withComplianceExpirationDateTime(OffsetDateTime complianceExpirationDateTime) {
        this.complianceExpirationDateTime = complianceExpirationDateTime;
        return this;
    }

    /**
     * Get the deviceId property: Unique identifier set by Azure Device Registration Service at the time of
     * registration.
     *
     * @return the deviceId value.
     */
    public String deviceId() {
        return this.deviceId;
    }

    /**
     * Set the deviceId property: Unique identifier set by Azure Device Registration Service at the time of
     * registration.
     *
     * @param deviceId the deviceId value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
     * Get the deviceMetadata property: For internal use only. Set to null.
     *
     * @return the deviceMetadata value.
     */
    public String deviceMetadata() {
        return this.deviceMetadata;
    }

    /**
     * Set the deviceMetadata property: For internal use only. Set to null.
     *
     * @param deviceMetadata the deviceMetadata value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withDeviceMetadata(String deviceMetadata) {
        this.deviceMetadata = deviceMetadata;
        return this;
    }

    /**
     * Get the deviceVersion property: For internal use only.
     *
     * @return the deviceVersion value.
     */
    public Integer deviceVersion() {
        return this.deviceVersion;
    }

    /**
     * Set the deviceVersion property: For internal use only.
     *
     * @param deviceVersion the deviceVersion value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withDeviceVersion(Integer deviceVersion) {
        this.deviceVersion = deviceVersion;
        return this;
    }

    /**
     * Get the displayName property: The display name for the device. Required.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the device. Required.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the isCompliant property: true if the device complies with Mobile Device Management (MDM) policies;
     * otherwise, false. Read-only. This can only be updated by Intune for any device OS type or by an approved MDM app
     * for Windows OS devices.
     *
     * @return the isCompliant value.
     */
    public Boolean isCompliant() {
        return this.isCompliant;
    }

    /**
     * Set the isCompliant property: true if the device complies with Mobile Device Management (MDM) policies;
     * otherwise, false. Read-only. This can only be updated by Intune for any device OS type or by an approved MDM app
     * for Windows OS devices.
     *
     * @param isCompliant the isCompliant value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withIsCompliant(Boolean isCompliant) {
        this.isCompliant = isCompliant;
        return this;
    }

    /**
     * Get the isManaged property: true if the device is managed by a Mobile Device Management (MDM) app; otherwise,
     * false. This can only be updated by Intune for any device OS type or by an approved MDM app for Windows OS
     * devices.
     *
     * @return the isManaged value.
     */
    public Boolean isManaged() {
        return this.isManaged;
    }

    /**
     * Set the isManaged property: true if the device is managed by a Mobile Device Management (MDM) app; otherwise,
     * false. This can only be updated by Intune for any device OS type or by an approved MDM app for Windows OS
     * devices.
     *
     * @param isManaged the isManaged value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withIsManaged(Boolean isManaged) {
        this.isManaged = isManaged;
        return this;
    }

    /**
     * Get the mdmAppId property: Application identifier used to register device into MDM. Read-only. Supports $filter.
     *
     * @return the mdmAppId value.
     */
    public String mdmAppId() {
        return this.mdmAppId;
    }

    /**
     * Set the mdmAppId property: Application identifier used to register device into MDM. Read-only. Supports $filter.
     *
     * @param mdmAppId the mdmAppId value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withMdmAppId(String mdmAppId) {
        this.mdmAppId = mdmAppId;
        return this;
    }

    /**
     * Get the onPremisesLastSyncDateTime property: The last time at which the object was synced with the on-premises
     * directory. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC
     * time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z' Read-only.
     *
     * @return the onPremisesLastSyncDateTime value.
     */
    public OffsetDateTime onPremisesLastSyncDateTime() {
        return this.onPremisesLastSyncDateTime;
    }

    /**
     * Set the onPremisesLastSyncDateTime property: The last time at which the object was synced with the on-premises
     * directory. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC
     * time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z' Read-only.
     *
     * @param onPremisesLastSyncDateTime the onPremisesLastSyncDateTime value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return this;
    }

    /**
     * Get the onPremisesSyncEnabled property: true if this object is synced from an on-premises directory; false if
     * this object was originally synced from an on-premises directory but is no longer synced; null if this object has
     * never been synced from an on-premises directory (default). Read-only.
     *
     * @return the onPremisesSyncEnabled value.
     */
    public Boolean onPremisesSyncEnabled() {
        return this.onPremisesSyncEnabled;
    }

    /**
     * Set the onPremisesSyncEnabled property: true if this object is synced from an on-premises directory; false if
     * this object was originally synced from an on-premises directory but is no longer synced; null if this object has
     * never been synced from an on-premises directory (default). Read-only.
     *
     * @param onPremisesSyncEnabled the onPremisesSyncEnabled value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        this.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return this;
    }

    /**
     * Get the operatingSystem property: The type of operating system on the device. Required.
     *
     * @return the operatingSystem value.
     */
    public String operatingSystem() {
        return this.operatingSystem;
    }

    /**
     * Set the operatingSystem property: The type of operating system on the device. Required.
     *
     * @param operatingSystem the operatingSystem value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    /**
     * Get the operatingSystemVersion property: The version of the operating system on the device. Required.
     *
     * @return the operatingSystemVersion value.
     */
    public String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    /**
     * Set the operatingSystemVersion property: The version of the operating system on the device. Required.
     *
     * @param operatingSystemVersion the operatingSystemVersion value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
        return this;
    }

    /**
     * Get the physicalIds property: For internal use only. Not nullable.
     *
     * @return the physicalIds value.
     */
    public List<String> physicalIds() {
        return this.physicalIds;
    }

    /**
     * Set the physicalIds property: For internal use only. Not nullable.
     *
     * @param physicalIds the physicalIds value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withPhysicalIds(List<String> physicalIds) {
        this.physicalIds = physicalIds;
        return this;
    }

    /**
     * Get the profileType property: The profile type of the device. Possible values:RegisteredDevice
     * (default)SecureVMPrinterSharedIoT.
     *
     * @return the profileType value.
     */
    public String profileType() {
        return this.profileType;
    }

    /**
     * Set the profileType property: The profile type of the device. Possible values:RegisteredDevice
     * (default)SecureVMPrinterSharedIoT.
     *
     * @param profileType the profileType value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withProfileType(String profileType) {
        this.profileType = profileType;
        return this;
    }

    /**
     * Get the systemLabels property: List of labels applied to the device by the system.
     *
     * @return the systemLabels value.
     */
    public List<String> systemLabels() {
        return this.systemLabels;
    }

    /**
     * Set the systemLabels property: List of labels applied to the device by the system.
     *
     * @param systemLabels the systemLabels value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withSystemLabels(List<String> systemLabels) {
        this.systemLabels = systemLabels;
        return this;
    }

    /**
     * Get the trustType property: Type of trust for the joined device. Read-only. Possible values: Workplace -
     * indicates bring your own personal devicesAzureAd - Cloud only joined devicesServerAd - on-premises domain joined
     * devices joined to Azure AD. For more details, see Introduction to device management in Azure Active Directory.
     *
     * @return the trustType value.
     */
    public String trustType() {
        return this.trustType;
    }

    /**
     * Set the trustType property: Type of trust for the joined device. Read-only. Possible values: Workplace -
     * indicates bring your own personal devicesAzureAd - Cloud only joined devicesServerAd - on-premises domain joined
     * devices joined to Azure AD. For more details, see Introduction to device management in Azure Active Directory.
     *
     * @param trustType the trustType value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withTrustType(String trustType) {
        this.trustType = trustType;
        return this;
    }

    /**
     * Get the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     *
     * @return the memberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> memberOf() {
        return this.memberOf;
    }

    /**
     * Set the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     *
     * @param memberOf the memberOf value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withMemberOf(List<MicrosoftGraphDirectoryObjectInner> memberOf) {
        this.memberOf = memberOf;
        return this;
    }

    /**
     * Get the registeredOwners property: The user that cloud joined the device or registered their personal device. The
     * registered owner is set at the time of registration. Currently, there can be only one owner. Read-only. Nullable.
     *
     * @return the registeredOwners value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> registeredOwners() {
        return this.registeredOwners;
    }

    /**
     * Set the registeredOwners property: The user that cloud joined the device or registered their personal device. The
     * registered owner is set at the time of registration. Currently, there can be only one owner. Read-only. Nullable.
     *
     * @param registeredOwners the registeredOwners value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withRegisteredOwners(List<MicrosoftGraphDirectoryObjectInner> registeredOwners) {
        this.registeredOwners = registeredOwners;
        return this;
    }

    /**
     * Get the registeredUsers property: Collection of registered users of the device. For cloud joined devices and
     * registered personal devices, registered users are set to the same value as registered owners at the time of
     * registration. Read-only. Nullable.
     *
     * @return the registeredUsers value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> registeredUsers() {
        return this.registeredUsers;
    }

    /**
     * Set the registeredUsers property: Collection of registered users of the device. For cloud joined devices and
     * registered personal devices, registered users are set to the same value as registered owners at the time of
     * registration. Read-only. Nullable.
     *
     * @param registeredUsers the registeredUsers value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withRegisteredUsers(List<MicrosoftGraphDirectoryObjectInner> registeredUsers) {
        this.registeredUsers = registeredUsers;
        return this;
    }

    /**
     * Get the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @return the transitiveMemberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf() {
        return this.transitiveMemberOf;
    }

    /**
     * Set the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @param transitiveMemberOf the transitiveMemberOf value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withTransitiveMemberOf(List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf) {
        this.transitiveMemberOf = transitiveMemberOf;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the device. Read-only. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the device. Read-only. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDevice object itself.
     */
    public MicrosoftGraphDevice withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphDevice withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphDevice withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (alternativeSecurityIds() != null) {
            alternativeSecurityIds().forEach(e -> e.validate());
        }
        if (memberOf() != null) {
            memberOf().forEach(e -> e.validate());
        }
        if (registeredOwners() != null) {
            registeredOwners().forEach(e -> e.validate());
        }
        if (registeredUsers() != null) {
            registeredUsers().forEach(e -> e.validate());
        }
        if (transitiveMemberOf() != null) {
            transitiveMemberOf().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
    }
}
