// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for MicrosoftGraphChatMessageType. */
public final class MicrosoftGraphChatMessageType extends ExpandableStringEnum<MicrosoftGraphChatMessageType> {
    /** Static value message for MicrosoftGraphChatMessageType. */
    public static final MicrosoftGraphChatMessageType MESSAGE = fromString("message");

    /** Static value chatEvent for MicrosoftGraphChatMessageType. */
    public static final MicrosoftGraphChatMessageType CHAT_EVENT = fromString("chatEvent");

    /** Static value typing for MicrosoftGraphChatMessageType. */
    public static final MicrosoftGraphChatMessageType TYPING = fromString("typing");

    /** Static value unknownFutureValue for MicrosoftGraphChatMessageType. */
    public static final MicrosoftGraphChatMessageType UNKNOWN_FUTURE_VALUE = fromString("unknownFutureValue");

    /**
     * Creates or finds a MicrosoftGraphChatMessageType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MicrosoftGraphChatMessageType.
     */
    @JsonCreator
    public static MicrosoftGraphChatMessageType fromString(String name) {
        return fromString(name, MicrosoftGraphChatMessageType.class);
    }

    /** @return known MicrosoftGraphChatMessageType values. */
    public static Collection<MicrosoftGraphChatMessageType> values() {
        return values(MicrosoftGraphChatMessageType.class);
    }
}
