// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/** assignedLicense. */
@Fluent
public final class MicrosoftGraphAssignedLicense {
    /*
     * A collection of the unique identifiers for plans that have been
     * disabled.
     */
    @JsonProperty(value = "disabledPlans")
    private List<UUID> disabledPlans;

    /*
     * The unique identifier for the SKU.
     */
    @JsonProperty(value = "skuId")
    private UUID skuId;

    /*
     * assignedLicense
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the disabledPlans property: A collection of the unique identifiers for plans that have been disabled.
     *
     * @return the disabledPlans value.
     */
    public List<UUID> disabledPlans() {
        return this.disabledPlans;
    }

    /**
     * Set the disabledPlans property: A collection of the unique identifiers for plans that have been disabled.
     *
     * @param disabledPlans the disabledPlans value to set.
     * @return the MicrosoftGraphAssignedLicense object itself.
     */
    public MicrosoftGraphAssignedLicense withDisabledPlans(List<UUID> disabledPlans) {
        this.disabledPlans = disabledPlans;
        return this;
    }

    /**
     * Get the skuId property: The unique identifier for the SKU.
     *
     * @return the skuId value.
     */
    public UUID skuId() {
        return this.skuId;
    }

    /**
     * Set the skuId property: The unique identifier for the SKU.
     *
     * @param skuId the skuId value to set.
     * @return the MicrosoftGraphAssignedLicense object itself.
     */
    public MicrosoftGraphAssignedLicense withSkuId(UUID skuId) {
        this.skuId = skuId;
        return this;
    }

    /**
     * Get the additionalProperties property: assignedLicense.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: assignedLicense.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAssignedLicense object itself.
     */
    public MicrosoftGraphAssignedLicense withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
