/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.models.PasswordProfile;
import com.azure.resourcemanager.authorization.models.UserBase;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class UserCreateParameters
extends UserBase {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(UserCreateParameters.class);
    @JsonProperty(value="accountEnabled", required=true)
    private boolean accountEnabled;
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="passwordProfile", required=true)
    private PasswordProfile passwordProfile;
    @JsonProperty(value="userPrincipalName", required=true)
    private String userPrincipalName;
    @JsonProperty(value="mailNickname", required=true)
    private String mailNickname;
    @JsonProperty(value="mail")
    private String mail;

    public boolean accountEnabled() {
        return this.accountEnabled;
    }

    public UserCreateParameters withAccountEnabled(boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public UserCreateParameters withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public PasswordProfile passwordProfile() {
        return this.passwordProfile;
    }

    public UserCreateParameters withPasswordProfile(PasswordProfile passwordProfile) {
        this.passwordProfile = passwordProfile;
        return this;
    }

    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    public UserCreateParameters withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public String mailNickname() {
        return this.mailNickname;
    }

    public UserCreateParameters withMailNickname(String mailNickname) {
        this.mailNickname = mailNickname;
        return this;
    }

    public String mail() {
        return this.mail;
    }

    public UserCreateParameters withMail(String mail) {
        this.mail = mail;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.displayName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model UserCreateParameters"));
        }
        if (this.passwordProfile() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property passwordProfile in model UserCreateParameters"));
        }
        this.passwordProfile().validate();
        if (this.userPrincipalName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property userPrincipalName in model UserCreateParameters"));
        }
        if (this.mailNickname() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property mailNickname in model UserCreateParameters"));
        }
    }
}

