/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import reactor.core.publisher.Mono;

class PasswordCredentialImpl<T extends HasCredential<T>>
extends IndexableRefreshableWrapperImpl<PasswordCredential, PasswordCredentialInner>
implements PasswordCredential,
PasswordCredential.Definition<T>,
PasswordCredential.UpdateDefinition<T> {
    private String name;
    private HasCredential<T> parent;
    OutputStream authFile;
    private String subscriptionId;
    private final ClientLogger logger = new ClientLogger(PasswordCredentialImpl.class);

    PasswordCredentialImpl(PasswordCredentialInner passwordCredential) {
        super((Object)passwordCredential);
        this.name = passwordCredential.customKeyIdentifier() != null && passwordCredential.customKeyIdentifier().length > 0 ? new String(Base64.getMimeDecoder().decode(new String(passwordCredential.customKeyIdentifier(), StandardCharsets.UTF_8)), StandardCharsets.UTF_8) : passwordCredential.keyId();
    }

    PasswordCredentialImpl(String name, HasCredential<T> parent) {
        super((Object)new PasswordCredentialInner().withCustomKeyIdentifier(Base64.getEncoder().encode(name.getBytes(StandardCharsets.UTF_8))).withStartDate(OffsetDateTime.now()).withEndDate(OffsetDateTime.now().plusYears(1L)));
        this.name = name;
        this.parent = parent;
    }

    public Mono<PasswordCredential> refreshAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    protected Mono<PasswordCredentialInner> getInnerAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    @Override
    public OffsetDateTime startDate() {
        return ((PasswordCredentialInner)this.innerModel()).startDate();
    }

    @Override
    public OffsetDateTime endDate() {
        return ((PasswordCredentialInner)this.innerModel()).endDate();
    }

    @Override
    public String value() {
        return ((PasswordCredentialInner)this.innerModel()).value();
    }

    public T attach() {
        return this.parent.withPasswordCredential(this);
    }

    @Override
    public PasswordCredentialImpl<T> withPasswordValue(String password) {
        ((PasswordCredentialInner)this.innerModel()).withValue(password);
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withStartDate(OffsetDateTime startDate) {
        OffsetDateTime original = this.startDate();
        ((PasswordCredentialInner)this.innerModel()).withStartDate(startDate);
        this.withDuration(Duration.between(original, this.endDate()));
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withDuration(Duration duration) {
        ((PasswordCredentialInner)this.innerModel()).withEndDate(this.startDate().plus(duration));
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withAuthFileToExport(OutputStream outputStream) {
        this.authFile = outputStream;
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        if (this.authFile == null) {
            return;
        }
        AzureEnvironment environment = AzureEnvironment.AZURE;
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", servicePrincipal.applicationId())).append("\n");
        builder.append("  ").append(String.format("\"clientSecret\": \"%s\",", this.value())).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", servicePrincipal.manager().tenantId())).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", servicePrincipal.assignedSubscription)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.getActiveDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.getResourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.getGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.getManagementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    public PasswordCredentialImpl<T> withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String id() {
        return ((PasswordCredentialInner)this.innerModel()).keyId();
    }

    public String name() {
        return this.name;
    }
}

