/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.DeletedApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.DomainsClient;
import com.azure.resourcemanager.authorization.fluent.GraphRbacManagementClient;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.OAuth2PermissionGrantsClient;
import com.azure.resourcemanager.authorization.fluent.ObjectsClient;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.SignedInUsersClient;
import com.azure.resourcemanager.authorization.fluent.UsersClient;
import com.azure.resourcemanager.authorization.implementation.ApplicationsClientImpl;
import com.azure.resourcemanager.authorization.implementation.DeletedApplicationsClientImpl;
import com.azure.resourcemanager.authorization.implementation.DomainsClientImpl;
import com.azure.resourcemanager.authorization.implementation.GroupsClientImpl;
import com.azure.resourcemanager.authorization.implementation.OAuth2PermissionGrantsClientImpl;
import com.azure.resourcemanager.authorization.implementation.ObjectsClientImpl;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalsClientImpl;
import com.azure.resourcemanager.authorization.implementation.SignedInUsersClientImpl;
import com.azure.resourcemanager.authorization.implementation.UsersClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class GraphRbacManagementClientImpl
extends AzureServiceClient
implements GraphRbacManagementClient {
    private final ClientLogger logger = new ClientLogger(GraphRbacManagementClientImpl.class);
    private final String tenantId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final SignedInUsersClient signedInUsers;
    private final ApplicationsClient applications;
    private final DeletedApplicationsClient deletedApplications;
    private final GroupsClient groups;
    private final ServicePrincipalsClient servicePrincipals;
    private final UsersClient users;
    private final ObjectsClient objects;
    private final DomainsClient domains;
    private final OAuth2PermissionGrantsClient oAuth2PermissionGrants;

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public SignedInUsersClient getSignedInUsers() {
        return this.signedInUsers;
    }

    @Override
    public ApplicationsClient getApplications() {
        return this.applications;
    }

    @Override
    public DeletedApplicationsClient getDeletedApplications() {
        return this.deletedApplications;
    }

    @Override
    public GroupsClient getGroups() {
        return this.groups;
    }

    @Override
    public ServicePrincipalsClient getServicePrincipals() {
        return this.servicePrincipals;
    }

    @Override
    public UsersClient getUsers() {
        return this.users;
    }

    @Override
    public ObjectsClient getObjects() {
        return this.objects;
    }

    @Override
    public DomainsClient getDomains() {
        return this.domains;
    }

    @Override
    public OAuth2PermissionGrantsClient getOAuth2PermissionGrants() {
        return this.oAuth2PermissionGrants;
    }

    GraphRbacManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String tenantId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.tenantId = tenantId;
        this.endpoint = endpoint;
        this.apiVersion = "1.6";
        this.signedInUsers = new SignedInUsersClientImpl(this);
        this.applications = new ApplicationsClientImpl(this);
        this.deletedApplications = new DeletedApplicationsClientImpl(this);
        this.groups = new GroupsClientImpl(this);
        this.servicePrincipals = new ServicePrincipalsClientImpl(this);
        this.users = new UsersClientImpl(this);
        this.objects = new ObjectsClientImpl(this);
        this.domains = new DomainsClientImpl(this);
        this.oAuth2PermissionGrants = new OAuth2PermissionGrantsClientImpl(this);
    }
}

