/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.azure.resourcemanager.authorization.models.PasswordProfile;
import com.azure.resourcemanager.authorization.models.UserCreateParameters;
import com.azure.resourcemanager.authorization.models.UserUpdateParameters;
import com.azure.resourcemanager.resources.fluentcore.arm.CountryIsoCode;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import reactor.core.publisher.Mono;

class ActiveDirectoryUserImpl
extends CreatableUpdatableImpl<ActiveDirectoryUser, UserInner, ActiveDirectoryUserImpl>
implements ActiveDirectoryUser,
ActiveDirectoryUser.Definition,
ActiveDirectoryUser.Update {
    private final AuthorizationManager manager;
    private UserCreateParameters createParameters;
    private UserUpdateParameters updateParameters;
    private String emailAlias;

    ActiveDirectoryUserImpl(UserInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new UserCreateParameters().withDisplayName(this.name()).withAccountEnabled(true);
        this.updateParameters = new UserUpdateParameters().withDisplayName(this.name());
    }

    @Override
    public String userPrincipalName() {
        return ((UserInner)this.innerModel()).userPrincipalName();
    }

    @Override
    public String signInName() {
        if (((UserInner)this.innerModel()).signInNames() != null && !((UserInner)this.innerModel()).signInNames().isEmpty()) {
            return ((UserInner)this.innerModel()).signInNames().get(0).value();
        }
        return null;
    }

    @Override
    public String mail() {
        return ((UserInner)this.innerModel()).mail();
    }

    @Override
    public String mailNickname() {
        return ((UserInner)this.innerModel()).mailNickname();
    }

    @Override
    public CountryIsoCode usageLocation() {
        return CountryIsoCode.fromString((String)((UserInner)this.innerModel()).usageLocation());
    }

    @Override
    public ActiveDirectoryUserImpl withUserPrincipalName(String userPrincipalName) {
        this.createParameters.withUserPrincipalName(userPrincipalName);
        if (this.isInCreateMode() || this.updateParameters.mailNickname() != null) {
            this.withMailNickname(userPrincipalName.replaceAll("@.+$", ""));
        }
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withEmailAlias(String emailAlias) {
        this.emailAlias = emailAlias;
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withPassword(String password) {
        this.createParameters.withPasswordProfile(new PasswordProfile().withPassword(password));
        this.updateParameters.withPasswordProfile(new PasswordProfile().withPassword(password));
        return this;
    }

    protected Mono<UserInner> getInnerAsync() {
        return this.manager.serviceClient().getUsers().getAsync(this.id());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<ActiveDirectoryUser> createResourceAsync() {
        Mono domain = null;
        if (this.emailAlias != null) {
            domain = (Mono)this.manager().serviceClient().getDomains().listAsync(null).map(domainInner -> {
                if (domainInner.isVerified().booleanValue() && domainInner.isDefault().booleanValue() && this.emailAlias != null) {
                    this.withUserPrincipalName(this.emailAlias + "@" + domainInner.name());
                }
                return Mono.just((Object)this);
            }).blockLast();
        }
        if (domain == null) {
            domain = Mono.just((Object)this);
        }
        return domain.flatMap(activeDirectoryUser -> this.manager().serviceClient().getUsers().createAsync(this.createParameters)).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<ActiveDirectoryUser> updateResourceAsync() {
        return this.manager().serviceClient().getUsers().updateAsync(this.id(), this.updateParameters).then(this.refreshAsync());
    }

    private void withMailNickname(String mailNickname) {
        this.createParameters.withMailNickname(mailNickname);
        this.updateParameters.withMailNickname(mailNickname);
    }

    @Override
    public ActiveDirectoryUserImpl withPromptToChangePasswordOnLogin(boolean promptToChangePasswordOnLogin) {
        this.createParameters.passwordProfile().withForceChangePasswordNextLogin(promptToChangePasswordOnLogin);
        this.updateParameters.passwordProfile().withForceChangePasswordNextLogin(promptToChangePasswordOnLogin);
        return this;
    }

    public String toString() {
        return this.name() + " - " + this.userPrincipalName();
    }

    @Override
    public ActiveDirectoryUserImpl withAccountEnabled(boolean accountEnabled) {
        this.createParameters.withAccountEnabled(accountEnabled);
        this.updateParameters.withAccountEnabled(accountEnabled);
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withUsageLocation(CountryIsoCode usageLocation) {
        this.createParameters.withUsageLocation(usageLocation.toString());
        this.updateParameters.withUsageLocation(usageLocation.toString());
        return this;
    }

    public String id() {
        return ((UserInner)this.innerModel()).objectId();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

