/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.ADGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryUserImpl;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryObject;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.azure.resourcemanager.authorization.models.GroupCreateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ActiveDirectoryGroupImpl
extends CreatableUpdatableImpl<ActiveDirectoryGroup, ADGroupInner, ActiveDirectoryGroupImpl>
implements ActiveDirectoryGroup,
ActiveDirectoryGroup.Definition,
ActiveDirectoryGroup.Update {
    private final AuthorizationManager manager;
    private GroupCreateParameters createParameters;
    private Set<String> membersToAdd;
    private Set<String> membersToRemove;

    ActiveDirectoryGroupImpl(ADGroupInner innerModel, AuthorizationManager manager) {
        super(innerModel.displayName(), (Object)innerModel);
        this.manager = manager;
        this.createParameters = new GroupCreateParameters().withDisplayName(innerModel.displayName()).withMailEnabled(false).withSecurityEnabled(true);
        this.membersToAdd = new HashSet<String>();
        this.membersToRemove = new HashSet<String>();
    }

    @Override
    public boolean securityEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ADGroupInner)this.innerModel()).securityEnabled());
    }

    @Override
    public String mail() {
        return ((ADGroupInner)this.innerModel()).mail();
    }

    @Override
    public List<ActiveDirectoryObject> listMembers() {
        return (List)this.listMembersAsync().collectList().block();
    }

    @Override
    public PagedFlux<ActiveDirectoryObject> listMembersAsync() {
        return this.manager().serviceClient().getGroups().getGroupMembersAsync(this.id()).mapPage(directoryObjectInner -> {
            if (directoryObjectInner instanceof UserInner) {
                return new ActiveDirectoryUserImpl((UserInner)directoryObjectInner, this.manager());
            }
            if (directoryObjectInner instanceof ADGroupInner) {
                return new ActiveDirectoryGroupImpl((ADGroupInner)directoryObjectInner, this.manager());
            }
            if (directoryObjectInner instanceof ServicePrincipalInner) {
                return new ServicePrincipalImpl((ServicePrincipalInner)directoryObjectInner, this.manager());
            }
            if (directoryObjectInner instanceof ApplicationInner) {
                return new ActiveDirectoryApplicationImpl((ApplicationInner)directoryObjectInner, this.manager());
            }
            return null;
        });
    }

    protected Mono<ADGroupInner> getInnerAsync() {
        return this.manager().serviceClient().getGroups().getAsync(this.id());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<ActiveDirectoryGroup> createResourceAsync() {
        Mono group = Mono.just((Object)this);
        if (this.isInCreateMode()) {
            group = this.manager().serviceClient().getGroups().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        if (!this.membersToRemove.isEmpty()) {
            group = group.flatMap(o -> Flux.fromIterable(this.membersToRemove).flatMap(s -> this.manager().serviceClient().getGroups().removeMemberAsync(this.id(), (String)s)).singleOrEmpty().thenReturn((Object)Mono.just((Object)this)).doFinally(signalType -> this.membersToRemove.clear()));
        }
        if (!this.membersToAdd.isEmpty()) {
            group = group.flatMap(o -> Flux.fromIterable(this.membersToAdd).flatMap(s -> this.manager().serviceClient().getGroups().addMemberAsync(this.id(), (String)s)).singleOrEmpty().thenReturn((Object)Mono.just((Object)this)).doFinally(signalType -> this.membersToAdd.clear()));
        }
        return group.map(o -> this);
    }

    @Override
    public ActiveDirectoryGroupImpl withEmailAlias(String mailNickname) {
        if (mailNickname.contains("@")) {
            String[] parts = mailNickname.split("@");
            mailNickname = parts[0];
        }
        this.createParameters.withMailNickname(mailNickname);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(String objectId) {
        this.membersToAdd.add(String.format("%s%s/directoryObjects/%s", this.manager().serviceClient().getEndpoint(), this.manager().tenantId(), objectId));
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryUser user) {
        return this.withMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryGroup group) {
        return this.withMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ServicePrincipal servicePrincipal) {
        return this.withMember(servicePrincipal.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(String objectId) {
        this.membersToRemove.add(objectId);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryUser user) {
        return this.withoutMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryGroup group) {
        return this.withoutMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ServicePrincipal servicePrincipal) {
        return this.withoutMember(servicePrincipal.id());
    }

    public String id() {
        return ((ADGroupInner)this.innerModel()).objectId();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

