/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.VirtualDirectory;
import java.io.IOException;
import java.util.List;

public final class VirtualApplication
implements JsonSerializable<VirtualApplication> {
    private String virtualPath;
    private String physicalPath;
    private Boolean preloadEnabled;
    private List<VirtualDirectory> virtualDirectories;

    public String virtualPath() {
        return this.virtualPath;
    }

    public VirtualApplication withVirtualPath(String virtualPath) {
        this.virtualPath = virtualPath;
        return this;
    }

    public String physicalPath() {
        return this.physicalPath;
    }

    public VirtualApplication withPhysicalPath(String physicalPath) {
        this.physicalPath = physicalPath;
        return this;
    }

    public Boolean preloadEnabled() {
        return this.preloadEnabled;
    }

    public VirtualApplication withPreloadEnabled(Boolean preloadEnabled) {
        this.preloadEnabled = preloadEnabled;
        return this;
    }

    public List<VirtualDirectory> virtualDirectories() {
        return this.virtualDirectories;
    }

    public VirtualApplication withVirtualDirectories(List<VirtualDirectory> virtualDirectories) {
        this.virtualDirectories = virtualDirectories;
        return this;
    }

    public void validate() {
        if (this.virtualDirectories() != null) {
            this.virtualDirectories().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualPath", this.virtualPath);
        jsonWriter.writeStringField("physicalPath", this.physicalPath);
        jsonWriter.writeBooleanField("preloadEnabled", this.preloadEnabled);
        jsonWriter.writeArrayField("virtualDirectories", this.virtualDirectories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualApplication fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualApplication)jsonReader.readObject(reader -> {
            VirtualApplication deserializedVirtualApplication = new VirtualApplication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualPath".equals(fieldName)) {
                    deserializedVirtualApplication.virtualPath = reader.getString();
                    continue;
                }
                if ("physicalPath".equals(fieldName)) {
                    deserializedVirtualApplication.physicalPath = reader.getString();
                    continue;
                }
                if ("preloadEnabled".equals(fieldName)) {
                    deserializedVirtualApplication.preloadEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("virtualDirectories".equals(fieldName)) {
                    List virtualDirectories;
                    deserializedVirtualApplication.virtualDirectories = virtualDirectories = reader.readArray(reader1 -> VirtualDirectory.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualApplication;
        });
    }
}

