/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StorageMigrationOptionsProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class StorageMigrationOptions
extends ProxyOnlyResource {
    private StorageMigrationOptionsProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private StorageMigrationOptionsProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public StorageMigrationOptions withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String azurefilesConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().azurefilesConnectionString();
    }

    public StorageMigrationOptions withAzurefilesConnectionString(String azurefilesConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageMigrationOptionsProperties();
        }
        this.innerProperties().withAzurefilesConnectionString(azurefilesConnectionString);
        return this;
    }

    public String azurefilesShare() {
        return this.innerProperties() == null ? null : this.innerProperties().azurefilesShare();
    }

    public StorageMigrationOptions withAzurefilesShare(String azurefilesShare) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageMigrationOptionsProperties();
        }
        this.innerProperties().withAzurefilesShare(azurefilesShare);
        return this;
    }

    public Boolean switchSiteAfterMigration() {
        return this.innerProperties() == null ? null : this.innerProperties().switchSiteAfterMigration();
    }

    public StorageMigrationOptions withSwitchSiteAfterMigration(Boolean switchSiteAfterMigration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageMigrationOptionsProperties();
        }
        this.innerProperties().withSwitchSiteAfterMigration(switchSiteAfterMigration);
        return this;
    }

    public Boolean blockWriteAccessToSite() {
        return this.innerProperties() == null ? null : this.innerProperties().blockWriteAccessToSite();
    }

    public StorageMigrationOptions withBlockWriteAccessToSite(Boolean blockWriteAccessToSite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageMigrationOptionsProperties();
        }
        this.innerProperties().withBlockWriteAccessToSite(blockWriteAccessToSite);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageMigrationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (StorageMigrationOptions)((Object)jsonReader.readObject(reader -> {
            StorageMigrationOptions deserializedStorageMigrationOptions = new StorageMigrationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageMigrationOptions.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageMigrationOptions.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageMigrationOptions.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStorageMigrationOptions.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageMigrationOptions.innerProperties = StorageMigrationOptionsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageMigrationOptions;
        }));
    }
}

