/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RunCorrelation;
import java.io.IOException;
import java.util.List;

public final class RunActionCorrelation
extends RunCorrelation {
    private String actionTrackingId;

    public String actionTrackingId() {
        return this.actionTrackingId;
    }

    public RunActionCorrelation withActionTrackingId(String actionTrackingId) {
        this.actionTrackingId = actionTrackingId;
        return this;
    }

    @Override
    public RunActionCorrelation withClientTrackingId(String clientTrackingId) {
        super.withClientTrackingId(clientTrackingId);
        return this;
    }

    @Override
    public RunActionCorrelation withClientKeywords(List<String> clientKeywords) {
        super.withClientKeywords(clientKeywords);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientTrackingId", this.clientTrackingId());
        jsonWriter.writeArrayField("clientKeywords", this.clientKeywords(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("actionTrackingId", this.actionTrackingId);
        return jsonWriter.writeEndObject();
    }

    public static RunActionCorrelation fromJson(JsonReader jsonReader) throws IOException {
        return (RunActionCorrelation)jsonReader.readObject(reader -> {
            RunActionCorrelation deserializedRunActionCorrelation = new RunActionCorrelation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientTrackingId".equals(fieldName)) {
                    deserializedRunActionCorrelation.withClientTrackingId(reader.getString());
                    continue;
                }
                if ("clientKeywords".equals(fieldName)) {
                    List clientKeywords = reader.readArray(reader1 -> reader1.getString());
                    deserializedRunActionCorrelation.withClientKeywords(clientKeywords);
                    continue;
                }
                if ("actionTrackingId".equals(fieldName)) {
                    deserializedRunActionCorrelation.actionTrackingId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunActionCorrelation;
        });
    }
}

