/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContentLink;
import java.io.IOException;

public final class Response
implements JsonSerializable<Response> {
    private Object headers;
    private Integer statusCode;
    private ContentLink bodyLink;

    public Object headers() {
        return this.headers;
    }

    public Response withHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public Response withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ContentLink bodyLink() {
        return this.bodyLink;
    }

    public Response withBodyLink(ContentLink bodyLink) {
        this.bodyLink = bodyLink;
        return this;
    }

    public void validate() {
        if (this.bodyLink() != null) {
            this.bodyLink().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.headers != null) {
            jsonWriter.writeUntypedField("headers", this.headers);
        }
        jsonWriter.writeNumberField("statusCode", (Number)this.statusCode);
        jsonWriter.writeJsonField("bodyLink", (JsonSerializable)this.bodyLink);
        return jsonWriter.writeEndObject();
    }

    public static Response fromJson(JsonReader jsonReader) throws IOException {
        return (Response)jsonReader.readObject(reader -> {
            Response deserializedResponse = new Response();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("headers".equals(fieldName)) {
                    deserializedResponse.headers = reader.readUntyped();
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    deserializedResponse.statusCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("bodyLink".equals(fieldName)) {
                    deserializedResponse.bodyLink = ContentLink.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponse;
        });
    }
}

