/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FlowEndpoints;
import java.io.IOException;

public final class FlowEndpointsConfiguration
implements JsonSerializable<FlowEndpointsConfiguration> {
    private FlowEndpoints workflow;
    private FlowEndpoints connector;

    public FlowEndpoints workflow() {
        return this.workflow;
    }

    public FlowEndpointsConfiguration withWorkflow(FlowEndpoints workflow) {
        this.workflow = workflow;
        return this;
    }

    public FlowEndpoints connector() {
        return this.connector;
    }

    public FlowEndpointsConfiguration withConnector(FlowEndpoints connector) {
        this.connector = connector;
        return this;
    }

    public void validate() {
        if (this.workflow() != null) {
            this.workflow().validate();
        }
        if (this.connector() != null) {
            this.connector().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("workflow", (JsonSerializable)this.workflow);
        jsonWriter.writeJsonField("connector", (JsonSerializable)this.connector);
        return jsonWriter.writeEndObject();
    }

    public static FlowEndpointsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FlowEndpointsConfiguration)jsonReader.readObject(reader -> {
            FlowEndpointsConfiguration deserializedFlowEndpointsConfiguration = new FlowEndpointsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workflow".equals(fieldName)) {
                    deserializedFlowEndpointsConfiguration.workflow = FlowEndpoints.fromJson(reader);
                    continue;
                }
                if ("connector".equals(fieldName)) {
                    deserializedFlowEndpointsConfiguration.connector = FlowEndpoints.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowEndpointsConfiguration;
        });
    }
}

