/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DiagnosticMetricSample;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DiagnosticMetricSet
implements JsonSerializable<DiagnosticMetricSet> {
    private String name;
    private String unit;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String timeGrain;
    private List<DiagnosticMetricSample> values;

    public String name() {
        return this.name;
    }

    public DiagnosticMetricSet withName(String name) {
        this.name = name;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public DiagnosticMetricSet withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DiagnosticMetricSet withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DiagnosticMetricSet withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String timeGrain() {
        return this.timeGrain;
    }

    public DiagnosticMetricSet withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public List<DiagnosticMetricSample> values() {
        return this.values;
    }

    public DiagnosticMetricSet withValues(List<DiagnosticMetricSample> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("timeGrain", this.timeGrain);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticMetricSet fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticMetricSet)jsonReader.readObject(reader -> {
            DiagnosticMetricSet deserializedDiagnosticMetricSet = new DiagnosticMetricSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDiagnosticMetricSet.name = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedDiagnosticMetricSet.unit = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedDiagnosticMetricSet.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedDiagnosticMetricSet.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedDiagnosticMetricSet.timeGrain = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedDiagnosticMetricSet.values = values = reader.readArray(reader1 -> DiagnosticMetricSample.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticMetricSet;
        });
    }
}

