/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.SiteExtensionType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class SiteExtensionInfoProperties
implements JsonSerializable<SiteExtensionInfoProperties> {
    private String extensionId;
    private String title;
    private SiteExtensionType extensionType;
    private String summary;
    private String description;
    private String version;
    private String extensionUrl;
    private String projectUrl;
    private String iconUrl;
    private String licenseUrl;
    private String feedUrl;
    private List<String> authors;
    private String installerCommandLineParams;
    private OffsetDateTime publishedDateTime;
    private Integer downloadCount;
    private Boolean localIsLatestVersion;
    private String localPath;
    private OffsetDateTime installedDateTime;
    private String provisioningState;
    private String comment;

    public String extensionId() {
        return this.extensionId;
    }

    public SiteExtensionInfoProperties withExtensionId(String extensionId) {
        this.extensionId = extensionId;
        return this;
    }

    public String title() {
        return this.title;
    }

    public SiteExtensionInfoProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public SiteExtensionType extensionType() {
        return this.extensionType;
    }

    public SiteExtensionInfoProperties withExtensionType(SiteExtensionType extensionType) {
        this.extensionType = extensionType;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public SiteExtensionInfoProperties withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SiteExtensionInfoProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String version() {
        return this.version;
    }

    public SiteExtensionInfoProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String extensionUrl() {
        return this.extensionUrl;
    }

    public SiteExtensionInfoProperties withExtensionUrl(String extensionUrl) {
        this.extensionUrl = extensionUrl;
        return this;
    }

    public String projectUrl() {
        return this.projectUrl;
    }

    public SiteExtensionInfoProperties withProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
        return this;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public SiteExtensionInfoProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public SiteExtensionInfoProperties withLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
        return this;
    }

    public String feedUrl() {
        return this.feedUrl;
    }

    public SiteExtensionInfoProperties withFeedUrl(String feedUrl) {
        this.feedUrl = feedUrl;
        return this;
    }

    public List<String> authors() {
        return this.authors;
    }

    public SiteExtensionInfoProperties withAuthors(List<String> authors) {
        this.authors = authors;
        return this;
    }

    public String installerCommandLineParams() {
        return this.installerCommandLineParams;
    }

    public SiteExtensionInfoProperties withInstallerCommandLineParams(String installerCommandLineParams) {
        this.installerCommandLineParams = installerCommandLineParams;
        return this;
    }

    public OffsetDateTime publishedDateTime() {
        return this.publishedDateTime;
    }

    public SiteExtensionInfoProperties withPublishedDateTime(OffsetDateTime publishedDateTime) {
        this.publishedDateTime = publishedDateTime;
        return this;
    }

    public Integer downloadCount() {
        return this.downloadCount;
    }

    public SiteExtensionInfoProperties withDownloadCount(Integer downloadCount) {
        this.downloadCount = downloadCount;
        return this;
    }

    public Boolean localIsLatestVersion() {
        return this.localIsLatestVersion;
    }

    public SiteExtensionInfoProperties withLocalIsLatestVersion(Boolean localIsLatestVersion) {
        this.localIsLatestVersion = localIsLatestVersion;
        return this;
    }

    public String localPath() {
        return this.localPath;
    }

    public SiteExtensionInfoProperties withLocalPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    public OffsetDateTime installedDateTime() {
        return this.installedDateTime;
    }

    public SiteExtensionInfoProperties withInstalledDateTime(OffsetDateTime installedDateTime) {
        this.installedDateTime = installedDateTime;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public SiteExtensionInfoProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public SiteExtensionInfoProperties withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extension_id", this.extensionId);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("extension_type", this.extensionType == null ? null : this.extensionType.toString());
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("extension_url", this.extensionUrl);
        jsonWriter.writeStringField("project_url", this.projectUrl);
        jsonWriter.writeStringField("icon_url", this.iconUrl);
        jsonWriter.writeStringField("license_url", this.licenseUrl);
        jsonWriter.writeStringField("feed_url", this.feedUrl);
        jsonWriter.writeArrayField("authors", this.authors, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("installer_command_line_params", this.installerCommandLineParams);
        jsonWriter.writeStringField("published_date_time", this.publishedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.publishedDateTime));
        jsonWriter.writeNumberField("download_count", (Number)this.downloadCount);
        jsonWriter.writeBooleanField("local_is_latest_version", this.localIsLatestVersion);
        jsonWriter.writeStringField("local_path", this.localPath);
        jsonWriter.writeStringField("installed_date_time", this.installedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.installedDateTime));
        jsonWriter.writeStringField("provisioningState", this.provisioningState);
        jsonWriter.writeStringField("comment", this.comment);
        return jsonWriter.writeEndObject();
    }

    public static SiteExtensionInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteExtensionInfoProperties)jsonReader.readObject(reader -> {
            SiteExtensionInfoProperties deserializedSiteExtensionInfoProperties = new SiteExtensionInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extension_id".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.extensionId = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.title = reader.getString();
                    continue;
                }
                if ("extension_type".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.extensionType = SiteExtensionType.fromString(reader.getString());
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.summary = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.description = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.version = reader.getString();
                    continue;
                }
                if ("extension_url".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.extensionUrl = reader.getString();
                    continue;
                }
                if ("project_url".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.projectUrl = reader.getString();
                    continue;
                }
                if ("icon_url".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.iconUrl = reader.getString();
                    continue;
                }
                if ("license_url".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.licenseUrl = reader.getString();
                    continue;
                }
                if ("feed_url".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.feedUrl = reader.getString();
                    continue;
                }
                if ("authors".equals(fieldName)) {
                    List authors;
                    deserializedSiteExtensionInfoProperties.authors = authors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("installer_command_line_params".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.installerCommandLineParams = reader.getString();
                    continue;
                }
                if ("published_date_time".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.publishedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("download_count".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.downloadCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("local_is_latest_version".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.localIsLatestVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("local_path".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.localPath = reader.getString();
                    continue;
                }
                if ("installed_date_time".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.installedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("comment".equals(fieldName)) {
                    deserializedSiteExtensionInfoProperties.comment = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteExtensionInfoProperties;
        });
    }
}

