/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CloneAbilityResult;
import com.azure.resourcemanager.appservice.models.SiteCloneabilityCriterion;
import java.io.IOException;
import java.util.List;

public final class SiteCloneabilityInner
implements JsonSerializable<SiteCloneabilityInner> {
    private CloneAbilityResult result;
    private List<SiteCloneabilityCriterion> blockingFeatures;
    private List<SiteCloneabilityCriterion> unsupportedFeatures;
    private List<SiteCloneabilityCriterion> blockingCharacteristics;

    public CloneAbilityResult result() {
        return this.result;
    }

    public SiteCloneabilityInner withResult(CloneAbilityResult result) {
        this.result = result;
        return this;
    }

    public List<SiteCloneabilityCriterion> blockingFeatures() {
        return this.blockingFeatures;
    }

    public SiteCloneabilityInner withBlockingFeatures(List<SiteCloneabilityCriterion> blockingFeatures) {
        this.blockingFeatures = blockingFeatures;
        return this;
    }

    public List<SiteCloneabilityCriterion> unsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    public SiteCloneabilityInner withUnsupportedFeatures(List<SiteCloneabilityCriterion> unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
        return this;
    }

    public List<SiteCloneabilityCriterion> blockingCharacteristics() {
        return this.blockingCharacteristics;
    }

    public SiteCloneabilityInner withBlockingCharacteristics(List<SiteCloneabilityCriterion> blockingCharacteristics) {
        this.blockingCharacteristics = blockingCharacteristics;
        return this;
    }

    public void validate() {
        if (this.blockingFeatures() != null) {
            this.blockingFeatures().forEach(e -> e.validate());
        }
        if (this.unsupportedFeatures() != null) {
            this.unsupportedFeatures().forEach(e -> e.validate());
        }
        if (this.blockingCharacteristics() != null) {
            this.blockingCharacteristics().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        jsonWriter.writeArrayField("blockingFeatures", this.blockingFeatures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("unsupportedFeatures", this.unsupportedFeatures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("blockingCharacteristics", this.blockingCharacteristics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SiteCloneabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteCloneabilityInner)jsonReader.readObject(reader -> {
            SiteCloneabilityInner deserializedSiteCloneabilityInner = new SiteCloneabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("result".equals(fieldName)) {
                    deserializedSiteCloneabilityInner.result = CloneAbilityResult.fromString(reader.getString());
                    continue;
                }
                if ("blockingFeatures".equals(fieldName)) {
                    List blockingFeatures;
                    deserializedSiteCloneabilityInner.blockingFeatures = blockingFeatures = reader.readArray(reader1 -> SiteCloneabilityCriterion.fromJson(reader1));
                    continue;
                }
                if ("unsupportedFeatures".equals(fieldName)) {
                    List unsupportedFeatures;
                    deserializedSiteCloneabilityInner.unsupportedFeatures = unsupportedFeatures = reader.readArray(reader1 -> SiteCloneabilityCriterion.fromJson(reader1));
                    continue;
                }
                if ("blockingCharacteristics".equals(fieldName)) {
                    List blockingCharacteristics;
                    deserializedSiteCloneabilityInner.blockingCharacteristics = blockingCharacteristics = reader.readArray(reader1 -> SiteCloneabilityCriterion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteCloneabilityInner;
        });
    }
}

