/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.InAvailabilityReasonType;
import java.io.IOException;

public final class DnlResourceNameAvailabilityInner
implements JsonSerializable<DnlResourceNameAvailabilityInner> {
    private String hostname;
    private Boolean nameAvailable;
    private InAvailabilityReasonType reason;
    private String message;

    public String hostname() {
        return this.hostname;
    }

    public DnlResourceNameAvailabilityInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    public DnlResourceNameAvailabilityInner withNameAvailable(Boolean nameAvailable) {
        this.nameAvailable = nameAvailable;
        return this;
    }

    public InAvailabilityReasonType reason() {
        return this.reason;
    }

    public DnlResourceNameAvailabilityInner withReason(InAvailabilityReasonType reason) {
        this.reason = reason;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DnlResourceNameAvailabilityInner withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeBooleanField("nameAvailable", this.nameAvailable);
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static DnlResourceNameAvailabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (DnlResourceNameAvailabilityInner)jsonReader.readObject(reader -> {
            DnlResourceNameAvailabilityInner deserializedDnlResourceNameAvailabilityInner = new DnlResourceNameAvailabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostName".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityInner.hostname = reader.getString();
                    continue;
                }
                if ("nameAvailable".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityInner.nameAvailable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityInner.reason = InAvailabilityReasonType.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityInner.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnlResourceNameAvailabilityInner;
        });
    }
}

