/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DeploymentProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DeploymentInner
extends ProxyOnlyResource {
    private DeploymentProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DeploymentProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public DeploymentInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public DeploymentInner withStatus(Integer status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    public DeploymentInner withMessage(String message) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withMessage(message);
        return this;
    }

    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    public DeploymentInner withAuthor(String author) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withAuthor(author);
        return this;
    }

    public String deployer() {
        return this.innerProperties() == null ? null : this.innerProperties().deployer();
    }

    public DeploymentInner withDeployer(String deployer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withDeployer(deployer);
        return this;
    }

    public String authorEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().authorEmail();
    }

    public DeploymentInner withAuthorEmail(String authorEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withAuthorEmail(authorEmail);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public DeploymentInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public DeploymentInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    public Boolean active() {
        return this.innerProperties() == null ? null : this.innerProperties().active();
    }

    public DeploymentInner withActive(Boolean active) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withActive(active);
        return this;
    }

    public String details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public DeploymentInner withDetails(String details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentInner)((Object)jsonReader.readObject(reader -> {
            DeploymentInner deserializedDeploymentInner = new DeploymentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeploymentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeploymentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDeploymentInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentInner.innerProperties = DeploymentProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentInner;
        }));
    }
}

