/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DnsVerificationTestResult;
import com.azure.resourcemanager.appservice.models.ErrorEntity;
import java.io.IOException;
import java.util.List;

public final class CustomHostnameAnalysisResultProperties
implements JsonSerializable<CustomHostnameAnalysisResultProperties> {
    private Boolean isHostnameAlreadyVerified;
    private DnsVerificationTestResult customDomainVerificationTest;
    private ErrorEntity customDomainVerificationFailureInfo;
    private Boolean hasConflictOnScaleUnit;
    private Boolean hasConflictAcrossSubscription;
    private String conflictingAppResourceId;
    private List<String> cNameRecords;
    private List<String> txtRecords;
    private List<String> aRecords;
    private List<String> alternateCNameRecords;
    private List<String> alternateTxtRecords;

    public Boolean isHostnameAlreadyVerified() {
        return this.isHostnameAlreadyVerified;
    }

    public DnsVerificationTestResult customDomainVerificationTest() {
        return this.customDomainVerificationTest;
    }

    public ErrorEntity customDomainVerificationFailureInfo() {
        return this.customDomainVerificationFailureInfo;
    }

    public Boolean hasConflictOnScaleUnit() {
        return this.hasConflictOnScaleUnit;
    }

    public Boolean hasConflictAcrossSubscription() {
        return this.hasConflictAcrossSubscription;
    }

    public String conflictingAppResourceId() {
        return this.conflictingAppResourceId;
    }

    public List<String> cNameRecords() {
        return this.cNameRecords;
    }

    public CustomHostnameAnalysisResultProperties withCNameRecords(List<String> cNameRecords) {
        this.cNameRecords = cNameRecords;
        return this;
    }

    public List<String> txtRecords() {
        return this.txtRecords;
    }

    public CustomHostnameAnalysisResultProperties withTxtRecords(List<String> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    public List<String> aRecords() {
        return this.aRecords;
    }

    public CustomHostnameAnalysisResultProperties withARecords(List<String> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    public List<String> alternateCNameRecords() {
        return this.alternateCNameRecords;
    }

    public CustomHostnameAnalysisResultProperties withAlternateCNameRecords(List<String> alternateCNameRecords) {
        this.alternateCNameRecords = alternateCNameRecords;
        return this;
    }

    public List<String> alternateTxtRecords() {
        return this.alternateTxtRecords;
    }

    public CustomHostnameAnalysisResultProperties withAlternateTxtRecords(List<String> alternateTxtRecords) {
        this.alternateTxtRecords = alternateTxtRecords;
        return this;
    }

    public void validate() {
        if (this.customDomainVerificationFailureInfo() != null) {
            this.customDomainVerificationFailureInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("cNameRecords", this.cNameRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("txtRecords", this.txtRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("aRecords", this.aRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateCNameRecords", this.alternateCNameRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateTxtRecords", this.alternateTxtRecords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CustomHostnameAnalysisResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CustomHostnameAnalysisResultProperties)jsonReader.readObject(reader -> {
            CustomHostnameAnalysisResultProperties deserializedCustomHostnameAnalysisResultProperties = new CustomHostnameAnalysisResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isHostnameAlreadyVerified".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.isHostnameAlreadyVerified = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDomainVerificationTest".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.customDomainVerificationTest = DnsVerificationTestResult.fromString(reader.getString());
                    continue;
                }
                if ("customDomainVerificationFailureInfo".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.customDomainVerificationFailureInfo = ErrorEntity.fromJson(reader);
                    continue;
                }
                if ("hasConflictOnScaleUnit".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.hasConflictOnScaleUnit = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hasConflictAcrossSubscription".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.hasConflictAcrossSubscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("conflictingAppResourceId".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.conflictingAppResourceId = reader.getString();
                    continue;
                }
                if ("cNameRecords".equals(fieldName)) {
                    List cNameRecords;
                    deserializedCustomHostnameAnalysisResultProperties.cNameRecords = cNameRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("txtRecords".equals(fieldName)) {
                    List txtRecords;
                    deserializedCustomHostnameAnalysisResultProperties.txtRecords = txtRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("aRecords".equals(fieldName)) {
                    List aRecords;
                    deserializedCustomHostnameAnalysisResultProperties.aRecords = aRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("alternateCNameRecords".equals(fieldName)) {
                    List alternateCNameRecords;
                    deserializedCustomHostnameAnalysisResultProperties.alternateCNameRecords = alternateCNameRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("alternateTxtRecords".equals(fieldName)) {
                    List alternateTxtRecords;
                    deserializedCustomHostnameAnalysisResultProperties.alternateTxtRecords = alternateTxtRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomHostnameAnalysisResultProperties;
        });
    }
}

