/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AseV3NetworkingConfigurationInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomDnsSuffixConfigurationInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import java.io.IOException;
import java.util.List;

public final class AppServiceEnvironmentInner
implements JsonSerializable<AppServiceEnvironmentInner> {
    private ProvisioningState provisioningState;
    private HostingEnvironmentStatus status;
    private VirtualNetworkProfile virtualNetwork;
    private LoadBalancingMode internalLoadBalancingMode;
    private String multiSize;
    private Integer multiRoleCount;
    private Integer ipsslAddressCount;
    private String dnsSuffix;
    private Integer maximumNumberOfMachines;
    private Integer frontEndScaleFactor;
    private Boolean suspended;
    private List<NameValuePair> clusterSettings;
    private List<String> userWhitelistedIpRanges;
    private Boolean hasLinuxWorkers;
    private UpgradePreference upgradePreference;
    private Integer dedicatedHostCount;
    private Boolean zoneRedundant;
    private CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration;
    private AseV3NetworkingConfigurationInner networkingConfiguration;
    private UpgradeAvailability upgradeAvailability;
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceEnvironmentInner.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironmentInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironmentInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironmentInner withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironmentInner withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironmentInner withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironmentInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironmentInner withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironmentInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public UpgradePreference upgradePreference() {
        return this.upgradePreference;
    }

    public AppServiceEnvironmentInner withUpgradePreference(UpgradePreference upgradePreference) {
        this.upgradePreference = upgradePreference;
        return this;
    }

    public Integer dedicatedHostCount() {
        return this.dedicatedHostCount;
    }

    public AppServiceEnvironmentInner withDedicatedHostCount(Integer dedicatedHostCount) {
        this.dedicatedHostCount = dedicatedHostCount;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public AppServiceEnvironmentInner withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.customDnsSuffixConfiguration;
    }

    public AppServiceEnvironmentInner withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        this.customDnsSuffixConfiguration = customDnsSuffixConfiguration;
        return this;
    }

    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.networkingConfiguration;
    }

    public AppServiceEnvironmentInner withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        this.networkingConfiguration = networkingConfiguration;
        return this;
    }

    public UpgradeAvailability upgradeAvailability() {
        return this.upgradeAvailability;
    }

    public void validate() {
        if (this.virtualNetwork() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model AppServiceEnvironmentInner"));
        }
        this.virtualNetwork().validate();
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
        if (this.customDnsSuffixConfiguration() != null) {
            this.customDnsSuffixConfiguration().validate();
        }
        if (this.networkingConfiguration() != null) {
            this.networkingConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        jsonWriter.writeStringField("internalLoadBalancingMode", this.internalLoadBalancingMode == null ? null : this.internalLoadBalancingMode.toString());
        jsonWriter.writeStringField("multiSize", this.multiSize);
        jsonWriter.writeNumberField("ipsslAddressCount", (Number)this.ipsslAddressCount);
        jsonWriter.writeStringField("dnsSuffix", this.dnsSuffix);
        jsonWriter.writeNumberField("frontEndScaleFactor", (Number)this.frontEndScaleFactor);
        jsonWriter.writeArrayField("clusterSettings", this.clusterSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userWhitelistedIpRanges", this.userWhitelistedIpRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("upgradePreference", this.upgradePreference == null ? null : this.upgradePreference.toString());
        jsonWriter.writeNumberField("dedicatedHostCount", (Number)this.dedicatedHostCount);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("customDnsSuffixConfiguration", (JsonSerializable)this.customDnsSuffixConfiguration);
        jsonWriter.writeJsonField("networkingConfiguration", (JsonSerializable)this.networkingConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static AppServiceEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppServiceEnvironmentInner)jsonReader.readObject(reader -> {
            AppServiceEnvironmentInner deserializedAppServiceEnvironmentInner = new AppServiceEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.virtualNetwork = VirtualNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.status = HostingEnvironmentStatus.fromString(reader.getString());
                    continue;
                }
                if ("internalLoadBalancingMode".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.internalLoadBalancingMode = LoadBalancingMode.fromString(reader.getString());
                    continue;
                }
                if ("multiSize".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.multiSize = reader.getString();
                    continue;
                }
                if ("multiRoleCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.multiRoleCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ipsslAddressCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.ipsslAddressCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsSuffix".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.dnsSuffix = reader.getString();
                    continue;
                }
                if ("maximumNumberOfMachines".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.maximumNumberOfMachines = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("frontEndScaleFactor".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.frontEndScaleFactor = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suspended".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.suspended = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clusterSettings".equals(fieldName)) {
                    List clusterSettings;
                    deserializedAppServiceEnvironmentInner.clusterSettings = clusterSettings = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                if ("userWhitelistedIpRanges".equals(fieldName)) {
                    List userWhitelistedIpRanges;
                    deserializedAppServiceEnvironmentInner.userWhitelistedIpRanges = userWhitelistedIpRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hasLinuxWorkers".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.hasLinuxWorkers = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("upgradePreference".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.upgradePreference = UpgradePreference.fromString(reader.getString());
                    continue;
                }
                if ("dedicatedHostCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.dedicatedHostCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDnsSuffixConfiguration".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.customDnsSuffixConfiguration = CustomDnsSuffixConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("networkingConfiguration".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.networkingConfiguration = AseV3NetworkingConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("upgradeAvailability".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.upgradeAvailability = UpgradeAvailability.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceEnvironmentInner;
        });
    }
}

