/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class StaticSitePatchResource
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSitePatchResource.class);
    @JsonProperty(value="properties.defaultHostname", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;
    @JsonProperty(value="properties.repositoryUrl")
    private String repositoryUrl;
    @JsonProperty(value="properties.branch")
    private String branch;
    @JsonProperty(value="properties.customDomains", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> customDomains;
    @JsonProperty(value="properties.repositoryToken")
    private String repositoryToken;
    @JsonProperty(value="properties.buildProperties")
    private StaticSiteBuildProperties buildProperties;

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSitePatchResource withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSitePatchResource withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String repositoryToken() {
        return this.repositoryToken;
    }

    public StaticSitePatchResource withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSitePatchResource withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
    }
}

