/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlots;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.appservice.models.FunctionRuntimeStack;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import java.util.Map;
import reactor.core.publisher.Mono;

public interface FunctionApp
extends FunctionAppBasic,
WebAppBase,
Updatable<Update> {
    public FunctionDeploymentSlots deploymentSlots();

    public StorageAccount storageAccount();

    public String getMasterKey();

    public Mono<String> getMasterKeyAsync();

    public PagedIterable<FunctionEnvelope> listFunctions();

    public Map<String, String> listFunctionKeys(String var1);

    public Mono<Map<String, String>> listFunctionKeysAsync(String var1);

    public NameValuePair addFunctionKey(String var1, String var2, String var3);

    public Mono<NameValuePair> addFunctionKeyAsync(String var1, String var2, String var3);

    public void removeFunctionKey(String var1, String var2);

    public Mono<Void> removeFunctionKeyAsync(String var1, String var2);

    public void triggerFunction(String var1, Object var2);

    public Mono<Void> triggerFunctionAsync(String var1, Object var2);

    public void syncTriggers();

    public Mono<Void> syncTriggersAsync();

    public static interface Update
    extends WebAppBase.Update<FunctionApp>,
    UpdateStages.WithAppServicePlan,
    UpdateStages.WithRuntimeVersion,
    UpdateStages.WithStorageAccount,
    UpdateStages.WithDailyUsageQuota,
    UpdateStages.WithDockerContainerImage,
    UpdateStages.WithCredentials {
    }

    public static interface UpdateStages {

        public static interface WithCredentials {
            public Update withCredentials(String var1, String var2);
        }

        public static interface WithDockerContainerImage {
            public Update withBuiltInImage(FunctionRuntimeStack var1);

            public Update withPublicDockerHubImage(String var1);

            public WithCredentials withPrivateDockerHubImage(String var1);

            public WithCredentials withPrivateRegistryImage(String var1, String var2);
        }

        public static interface WithDailyUsageQuota {
            public Update withDailyUsageQuota(int var1);

            public Update withoutDailyUsageQuota();
        }

        public static interface WithStorageAccount {
            public Update withNewStorageAccount(String var1, StorageAccountSkuType var2);

            public Update withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithRuntimeVersion {
            public Update withRuntime(String var1);

            public Update withRuntimeVersion(String var1);

            public Update withLatestRuntimeVersion();
        }

        public static interface WithAppServicePlan {
            public Update withNewConsumptionPlan();

            public Update withNewConsumptionPlan(String var1);

            public Update withNewFreeAppServicePlan();

            public Update withNewSharedAppServicePlan();

            public Update withNewAppServicePlan(PricingTier var1);

            public Update withNewAppServicePlan(String var1, PricingTier var2);

            public Update withNewAppServicePlan(Creatable<AppServicePlan> var1);

            public Update withExistingAppServicePlan(AppServicePlan var1);

            public Update withExistingLinuxAppServicePlan(AppServicePlan var1);

            public Update withNewLinuxConsumptionPlan();

            public Update withNewLinuxConsumptionPlan(String var1);

            public Update withNewLinuxAppServicePlan(PricingTier var1);

            public Update withNewLinuxAppServicePlan(String var1, PricingTier var2);

            public Update withNewLinuxAppServicePlan(Creatable<AppServicePlan> var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCredentials {
            public WithCreate withCredentials(String var1, String var2);
        }

        public static interface WithDockerContainerImage {
            public WithCreate withBuiltInImage(FunctionRuntimeStack var1);

            public WithCreate withPublicDockerHubImage(String var1);

            public WithCredentials withPrivateDockerHubImage(String var1);

            public WithCredentials withPrivateRegistryImage(String var1, String var2);
        }

        public static interface ExistingLinuxPlanWithGroup {
            public WithDockerContainerImage withExistingResourceGroup(String var1);

            public WithDockerContainerImage withExistingResourceGroup(ResourceGroup var1);

            public WithDockerContainerImage withNewResourceGroup(String var1);

            public WithDockerContainerImage withNewResourceGroup();

            public WithDockerContainerImage withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface WithCreate
        extends Creatable<FunctionApp>,
        WithNewAppServicePlan,
        WithStorageAccount,
        WithRuntimeVersion,
        WithDailyUsageQuota,
        WebAppBase.DefinitionStages.WithCreate<FunctionApp> {
        }

        public static interface WithDailyUsageQuota {
            public WithCreate withDailyUsageQuota(int var1);

            public WithCreate withoutDailyUsageQuota();
        }

        public static interface WithRuntimeVersion {
            public WithCreate withRuntime(String var1);

            public WithCreate withRuntimeVersion(String var1);

            public WithCreate withLatestRuntimeVersion();
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1, StorageAccountSkuType var2);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithNewAppServicePlan {
            public WithCreate withNewConsumptionPlan();

            public WithCreate withNewConsumptionPlan(String var1);

            public WithCreate withNewFreeAppServicePlan();

            public WithCreate withNewSharedAppServicePlan();

            public WithCreate withNewAppServicePlan(PricingTier var1);

            public WithCreate withNewAppServicePlan(String var1, PricingTier var2);

            public WithCreate withNewAppServicePlan(Creatable<AppServicePlan> var1);

            public WithDockerContainerImage withNewLinuxConsumptionPlan();

            public WithDockerContainerImage withNewLinuxConsumptionPlan(String var1);

            public WithDockerContainerImage withNewLinuxAppServicePlan(PricingTier var1);

            public WithDockerContainerImage withNewLinuxAppServicePlan(String var1, PricingTier var2);

            public WithDockerContainerImage withNewLinuxAppServicePlan(Creatable<AppServicePlan> var1);
        }

        public static interface NewAppServicePlanWithGroup {
            public WithCreate withExistingResourceGroup(String var1);

            public WithCreate withExistingResourceGroup(ResourceGroup var1);

            public WithCreate withNewResourceGroup(String var1);

            public WithCreate withNewResourceGroup();

            public WithCreate withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface ExistingAppServicePlanWithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<NewAppServicePlanWithGroup> {
            public ExistingAppServicePlanWithGroup withExistingAppServicePlan(AppServicePlan var1);

            public ExistingLinuxPlanWithGroup withExistingLinuxAppServicePlan(AppServicePlan var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.ExistingAppServicePlanWithGroup,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithDockerContainerImage,
    DefinitionStages.WithCredentials,
    DefinitionStages.WithCreate {
    }
}

