/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.StampCapacityInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.InternalLoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.NetworkAccessControlEntry;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VirtualIpMapping;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.azure.resourcemanager.appservice.models.WorkerPool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class AppServiceEnvironmentPatchResource
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppServiceEnvironmentPatchResource.class);
    @JsonProperty(value="properties.name")
    private String namePropertiesName;
    @JsonProperty(value="properties.location")
    private String location;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentStatus status;
    @JsonProperty(value="properties.vnetName")
    private String vnetName;
    @JsonProperty(value="properties.vnetResourceGroupName")
    private String vnetResourceGroupName;
    @JsonProperty(value="properties.vnetSubnetName")
    private String vnetSubnetName;
    @JsonProperty(value="properties.virtualNetwork")
    private VirtualNetworkProfile virtualNetwork;
    @JsonProperty(value="properties.internalLoadBalancingMode")
    private InternalLoadBalancingMode internalLoadBalancingMode;
    @JsonProperty(value="properties.multiSize")
    private String multiSize;
    @JsonProperty(value="properties.multiRoleCount")
    private Integer multiRoleCount;
    @JsonProperty(value="properties.workerPools")
    private List<WorkerPool> workerPools;
    @JsonProperty(value="properties.ipsslAddressCount")
    private Integer ipsslAddressCount;
    @JsonProperty(value="properties.databaseEdition", access=JsonProperty.Access.WRITE_ONLY)
    private String databaseEdition;
    @JsonProperty(value="properties.databaseServiceObjective", access=JsonProperty.Access.WRITE_ONLY)
    private String databaseServiceObjective;
    @JsonProperty(value="properties.upgradeDomains", access=JsonProperty.Access.WRITE_ONLY)
    private Integer upgradeDomains;
    @JsonProperty(value="properties.subscriptionId", access=JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;
    @JsonProperty(value="properties.dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="properties.lastAction", access=JsonProperty.Access.WRITE_ONLY)
    private String lastAction;
    @JsonProperty(value="properties.lastActionResult", access=JsonProperty.Access.WRITE_ONLY)
    private String lastActionResult;
    @JsonProperty(value="properties.allowedMultiSizes", access=JsonProperty.Access.WRITE_ONLY)
    private String allowedMultiSizes;
    @JsonProperty(value="properties.allowedWorkerSizes", access=JsonProperty.Access.WRITE_ONLY)
    private String allowedWorkerSizes;
    @JsonProperty(value="properties.maximumNumberOfMachines", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maximumNumberOfMachines;
    @JsonProperty(value="properties.vipMappings", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualIpMapping> vipMappings;
    @JsonProperty(value="properties.environmentCapacities", access=JsonProperty.Access.WRITE_ONLY)
    private List<StampCapacityInner> environmentCapacities;
    @JsonProperty(value="properties.networkAccessControlList")
    private List<NetworkAccessControlEntry> networkAccessControlList;
    @JsonProperty(value="properties.environmentIsHealthy", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean environmentIsHealthy;
    @JsonProperty(value="properties.environmentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String environmentStatus;
    @JsonProperty(value="properties.resourceGroup", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGroup;
    @JsonProperty(value="properties.frontEndScaleFactor")
    private Integer frontEndScaleFactor;
    @JsonProperty(value="properties.defaultFrontEndScaleFactor", access=JsonProperty.Access.WRITE_ONLY)
    private Integer defaultFrontEndScaleFactor;
    @JsonProperty(value="properties.apiManagementAccountId")
    private String apiManagementAccountId;
    @JsonProperty(value="properties.suspended")
    private Boolean suspended;
    @JsonProperty(value="properties.dynamicCacheEnabled")
    private Boolean dynamicCacheEnabled;
    @JsonProperty(value="properties.clusterSettings")
    private List<NameValuePair> clusterSettings;
    @JsonProperty(value="properties.userWhitelistedIpRanges")
    private List<String> userWhitelistedIpRanges;
    @JsonProperty(value="properties.hasLinuxWorkers")
    private Boolean hasLinuxWorkers;
    @JsonProperty(value="properties.sslCertKeyVaultId")
    private String sslCertKeyVaultId;
    @JsonProperty(value="properties.sslCertKeyVaultSecretName")
    private String sslCertKeyVaultSecretName;

    public String namePropertiesName() {
        return this.namePropertiesName;
    }

    public AppServiceEnvironmentPatchResource withNamePropertiesName(String namePropertiesName) {
        this.namePropertiesName = namePropertiesName;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AppServiceEnvironmentPatchResource withLocation(String location) {
        this.location = location;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public String vnetName() {
        return this.vnetName;
    }

    public AppServiceEnvironmentPatchResource withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    public String vnetResourceGroupName() {
        return this.vnetResourceGroupName;
    }

    public AppServiceEnvironmentPatchResource withVnetResourceGroupName(String vnetResourceGroupName) {
        this.vnetResourceGroupName = vnetResourceGroupName;
        return this;
    }

    public String vnetSubnetName() {
        return this.vnetSubnetName;
    }

    public AppServiceEnvironmentPatchResource withVnetSubnetName(String vnetSubnetName) {
        this.vnetSubnetName = vnetSubnetName;
        return this;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironmentPatchResource withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public InternalLoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironmentPatchResource withInternalLoadBalancingMode(InternalLoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironmentPatchResource withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public AppServiceEnvironmentPatchResource withMultiRoleCount(Integer multiRoleCount) {
        this.multiRoleCount = multiRoleCount;
        return this;
    }

    public List<WorkerPool> workerPools() {
        return this.workerPools;
    }

    public AppServiceEnvironmentPatchResource withWorkerPools(List<WorkerPool> workerPools) {
        this.workerPools = workerPools;
        return this;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironmentPatchResource withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String databaseEdition() {
        return this.databaseEdition;
    }

    public String databaseServiceObjective() {
        return this.databaseServiceObjective;
    }

    public Integer upgradeDomains() {
        return this.upgradeDomains;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironmentPatchResource withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public String lastAction() {
        return this.lastAction;
    }

    public String lastActionResult() {
        return this.lastActionResult;
    }

    public String allowedMultiSizes() {
        return this.allowedMultiSizes;
    }

    public String allowedWorkerSizes() {
        return this.allowedWorkerSizes;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public List<VirtualIpMapping> vipMappings() {
        return this.vipMappings;
    }

    public List<StampCapacityInner> environmentCapacities() {
        return this.environmentCapacities;
    }

    public List<NetworkAccessControlEntry> networkAccessControlList() {
        return this.networkAccessControlList;
    }

    public AppServiceEnvironmentPatchResource withNetworkAccessControlList(List<NetworkAccessControlEntry> networkAccessControlList) {
        this.networkAccessControlList = networkAccessControlList;
        return this;
    }

    public Boolean environmentIsHealthy() {
        return this.environmentIsHealthy;
    }

    public String environmentStatus() {
        return this.environmentStatus;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironmentPatchResource withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Integer defaultFrontEndScaleFactor() {
        return this.defaultFrontEndScaleFactor;
    }

    public String apiManagementAccountId() {
        return this.apiManagementAccountId;
    }

    public AppServiceEnvironmentPatchResource withApiManagementAccountId(String apiManagementAccountId) {
        this.apiManagementAccountId = apiManagementAccountId;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public AppServiceEnvironmentPatchResource withSuspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    public Boolean dynamicCacheEnabled() {
        return this.dynamicCacheEnabled;
    }

    public AppServiceEnvironmentPatchResource withDynamicCacheEnabled(Boolean dynamicCacheEnabled) {
        this.dynamicCacheEnabled = dynamicCacheEnabled;
        return this;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironmentPatchResource withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironmentPatchResource withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public AppServiceEnvironmentPatchResource withHasLinuxWorkers(Boolean hasLinuxWorkers) {
        this.hasLinuxWorkers = hasLinuxWorkers;
        return this;
    }

    public String sslCertKeyVaultId() {
        return this.sslCertKeyVaultId;
    }

    public AppServiceEnvironmentPatchResource withSslCertKeyVaultId(String sslCertKeyVaultId) {
        this.sslCertKeyVaultId = sslCertKeyVaultId;
        return this;
    }

    public String sslCertKeyVaultSecretName() {
        return this.sslCertKeyVaultSecretName;
    }

    public AppServiceEnvironmentPatchResource withSslCertKeyVaultSecretName(String sslCertKeyVaultSecretName) {
        this.sslCertKeyVaultSecretName = sslCertKeyVaultSecretName;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.virtualNetwork() != null) {
            this.virtualNetwork().validate();
        }
        if (this.workerPools() != null) {
            this.workerPools().forEach(e -> e.validate());
        }
        if (this.vipMappings() != null) {
            this.vipMappings().forEach(e -> e.validate());
        }
        if (this.environmentCapacities() != null) {
            this.environmentCapacities().forEach(e -> e.validate());
        }
        if (this.networkAccessControlList() != null) {
            this.networkAccessControlList().forEach(e -> e.validate());
        }
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
    }
}

