/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.StampCapacityInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.InternalLoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.NetworkAccessControlEntry;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.VirtualIpMapping;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.azure.resourcemanager.appservice.models.WorkerPool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AppServiceEnvironment {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppServiceEnvironment.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentStatus status;
    @JsonProperty(value="vnetName")
    private String vnetName;
    @JsonProperty(value="vnetResourceGroupName")
    private String vnetResourceGroupName;
    @JsonProperty(value="vnetSubnetName")
    private String vnetSubnetName;
    @JsonProperty(value="virtualNetwork", required=true)
    private VirtualNetworkProfile virtualNetwork;
    @JsonProperty(value="internalLoadBalancingMode")
    private InternalLoadBalancingMode internalLoadBalancingMode;
    @JsonProperty(value="multiSize")
    private String multiSize;
    @JsonProperty(value="multiRoleCount")
    private Integer multiRoleCount;
    @JsonProperty(value="workerPools", required=true)
    private List<WorkerPool> workerPools;
    @JsonProperty(value="ipsslAddressCount")
    private Integer ipsslAddressCount;
    @JsonProperty(value="databaseEdition", access=JsonProperty.Access.WRITE_ONLY)
    private String databaseEdition;
    @JsonProperty(value="databaseServiceObjective", access=JsonProperty.Access.WRITE_ONLY)
    private String databaseServiceObjective;
    @JsonProperty(value="upgradeDomains", access=JsonProperty.Access.WRITE_ONLY)
    private Integer upgradeDomains;
    @JsonProperty(value="subscriptionId", access=JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;
    @JsonProperty(value="dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="lastAction", access=JsonProperty.Access.WRITE_ONLY)
    private String lastAction;
    @JsonProperty(value="lastActionResult", access=JsonProperty.Access.WRITE_ONLY)
    private String lastActionResult;
    @JsonProperty(value="allowedMultiSizes", access=JsonProperty.Access.WRITE_ONLY)
    private String allowedMultiSizes;
    @JsonProperty(value="allowedWorkerSizes", access=JsonProperty.Access.WRITE_ONLY)
    private String allowedWorkerSizes;
    @JsonProperty(value="maximumNumberOfMachines", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maximumNumberOfMachines;
    @JsonProperty(value="vipMappings", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualIpMapping> vipMappings;
    @JsonProperty(value="environmentCapacities", access=JsonProperty.Access.WRITE_ONLY)
    private List<StampCapacityInner> environmentCapacities;
    @JsonProperty(value="networkAccessControlList")
    private List<NetworkAccessControlEntry> networkAccessControlList;
    @JsonProperty(value="environmentIsHealthy", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean environmentIsHealthy;
    @JsonProperty(value="environmentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String environmentStatus;
    @JsonProperty(value="resourceGroup", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGroup;
    @JsonProperty(value="frontEndScaleFactor")
    private Integer frontEndScaleFactor;
    @JsonProperty(value="defaultFrontEndScaleFactor", access=JsonProperty.Access.WRITE_ONLY)
    private Integer defaultFrontEndScaleFactor;
    @JsonProperty(value="apiManagementAccountId")
    private String apiManagementAccountId;
    @JsonProperty(value="suspended")
    private Boolean suspended;
    @JsonProperty(value="dynamicCacheEnabled")
    private Boolean dynamicCacheEnabled;
    @JsonProperty(value="clusterSettings")
    private List<NameValuePair> clusterSettings;
    @JsonProperty(value="userWhitelistedIpRanges")
    private List<String> userWhitelistedIpRanges;
    @JsonProperty(value="hasLinuxWorkers")
    private Boolean hasLinuxWorkers;
    @JsonProperty(value="sslCertKeyVaultId")
    private String sslCertKeyVaultId;
    @JsonProperty(value="sslCertKeyVaultSecretName")
    private String sslCertKeyVaultSecretName;

    public String name() {
        return this.name;
    }

    public AppServiceEnvironment withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AppServiceEnvironment withLocation(String location) {
        this.location = location;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public String vnetName() {
        return this.vnetName;
    }

    public AppServiceEnvironment withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    public String vnetResourceGroupName() {
        return this.vnetResourceGroupName;
    }

    public AppServiceEnvironment withVnetResourceGroupName(String vnetResourceGroupName) {
        this.vnetResourceGroupName = vnetResourceGroupName;
        return this;
    }

    public String vnetSubnetName() {
        return this.vnetSubnetName;
    }

    public AppServiceEnvironment withVnetSubnetName(String vnetSubnetName) {
        this.vnetSubnetName = vnetSubnetName;
        return this;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironment withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public InternalLoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironment withInternalLoadBalancingMode(InternalLoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironment withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public AppServiceEnvironment withMultiRoleCount(Integer multiRoleCount) {
        this.multiRoleCount = multiRoleCount;
        return this;
    }

    public List<WorkerPool> workerPools() {
        return this.workerPools;
    }

    public AppServiceEnvironment withWorkerPools(List<WorkerPool> workerPools) {
        this.workerPools = workerPools;
        return this;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironment withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String databaseEdition() {
        return this.databaseEdition;
    }

    public String databaseServiceObjective() {
        return this.databaseServiceObjective;
    }

    public Integer upgradeDomains() {
        return this.upgradeDomains;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironment withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public String lastAction() {
        return this.lastAction;
    }

    public String lastActionResult() {
        return this.lastActionResult;
    }

    public String allowedMultiSizes() {
        return this.allowedMultiSizes;
    }

    public String allowedWorkerSizes() {
        return this.allowedWorkerSizes;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public List<VirtualIpMapping> vipMappings() {
        return this.vipMappings;
    }

    public List<StampCapacityInner> environmentCapacities() {
        return this.environmentCapacities;
    }

    public List<NetworkAccessControlEntry> networkAccessControlList() {
        return this.networkAccessControlList;
    }

    public AppServiceEnvironment withNetworkAccessControlList(List<NetworkAccessControlEntry> networkAccessControlList) {
        this.networkAccessControlList = networkAccessControlList;
        return this;
    }

    public Boolean environmentIsHealthy() {
        return this.environmentIsHealthy;
    }

    public String environmentStatus() {
        return this.environmentStatus;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironment withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Integer defaultFrontEndScaleFactor() {
        return this.defaultFrontEndScaleFactor;
    }

    public String apiManagementAccountId() {
        return this.apiManagementAccountId;
    }

    public AppServiceEnvironment withApiManagementAccountId(String apiManagementAccountId) {
        this.apiManagementAccountId = apiManagementAccountId;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public AppServiceEnvironment withSuspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    public Boolean dynamicCacheEnabled() {
        return this.dynamicCacheEnabled;
    }

    public AppServiceEnvironment withDynamicCacheEnabled(Boolean dynamicCacheEnabled) {
        this.dynamicCacheEnabled = dynamicCacheEnabled;
        return this;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironment withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironment withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public AppServiceEnvironment withHasLinuxWorkers(Boolean hasLinuxWorkers) {
        this.hasLinuxWorkers = hasLinuxWorkers;
        return this;
    }

    public String sslCertKeyVaultId() {
        return this.sslCertKeyVaultId;
    }

    public AppServiceEnvironment withSslCertKeyVaultId(String sslCertKeyVaultId) {
        this.sslCertKeyVaultId = sslCertKeyVaultId;
        return this;
    }

    public String sslCertKeyVaultSecretName() {
        return this.sslCertKeyVaultSecretName;
    }

    public AppServiceEnvironment withSslCertKeyVaultSecretName(String sslCertKeyVaultSecretName) {
        this.sslCertKeyVaultSecretName = sslCertKeyVaultSecretName;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model AppServiceEnvironment"));
        }
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model AppServiceEnvironment"));
        }
        if (this.virtualNetwork() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model AppServiceEnvironment"));
        }
        this.virtualNetwork().validate();
        if (this.workerPools() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property workerPools in model AppServiceEnvironment"));
        }
        this.workerPools().forEach(e -> e.validate());
        if (this.vipMappings() != null) {
            this.vipMappings().forEach(e -> e.validate());
        }
        if (this.environmentCapacities() != null) {
            this.environmentCapacities().forEach(e -> e.validate());
        }
        if (this.networkAccessControlList() != null) {
            this.networkAccessControlList().forEach(e -> e.validate());
        }
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
    }
}

