/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBasicImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppImpl;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.azure.resourcemanager.appservice.models.WebApps;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsBatchDeletion;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebAppsImpl
extends GroupableResourcesImpl<WebApp, WebAppImpl, SiteInner, WebAppsClient, AppServiceManager>
implements WebApps,
SupportsBatchDeletion {
    public WebAppsImpl(AppServiceManager manager) {
        super((Object)((WebSiteManagementClient)manager.serviceClient()).getWebApps(), (Manager)manager);
    }

    public Mono<WebApp> getByResourceGroupAsync(String groupName, String name) {
        WebAppsImpl self = this;
        return this.getInnerAsync(groupName, name).flatMap(siteInner -> Mono.zip(((WebAppsClient)self.inner()).getConfigurationAsync(groupName, name), ((WebAppsClient)self.inner()).getDiagnosticLogsConfigurationAsync(groupName, name), (siteConfigResourceInner, logsConfigInner) -> this.wrapModel((SiteInner)((Object)siteInner), (SiteConfigResourceInner)((Object)((Object)siteConfigResourceInner)), (SiteLogsConfigInner)((Object)((Object)logsConfigInner)))));
    }

    protected Mono<SiteInner> getInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).deleteAsync(resourceGroupName, name).then();
    }

    protected WebAppImpl wrapModel(String name) {
        return new WebAppImpl(name, new SiteInner().withKind("app"), null, null, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new WebAppImpl(inner.name(), inner, siteConfig, logConfig, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null, null);
    }

    public WebAppImpl define(String name) {
        return this.wrapModel(name);
    }

    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).blockLast();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public PagedIterable<WebAppBasic> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<WebAppBasic> listByResourceGroupAsync(String resourceGroupName) {
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listByResourceGroupAsync(resourceGroupName), inner -> WebAppsImpl.isWebApp(inner) ? Mono.just((Object)new WebAppBasicImpl((SiteInner)((Object)inner), (AppServiceManager)this.manager())) : Mono.empty());
    }

    public PagedIterable<WebAppBasic> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<WebAppBasic> listAsync() {
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listAsync(), inner -> WebAppsImpl.isWebApp(inner) ? Mono.just((Object)new WebAppBasicImpl((SiteInner)((Object)inner), (AppServiceManager)this.manager())) : Mono.empty());
    }

    private static boolean isWebApp(SiteInner inner) {
        boolean ret = false;
        if (inner.kind() == null) {
            ret = true;
        } else {
            List<String> kinds = Arrays.asList(inner.kind().split(","));
            if (kinds.contains("app") || kinds.contains("api")) {
                ret = true;
            }
        }
        return ret;
    }
}

