/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentityType;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentityUserAssignedIdentities;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class WebAppMsiHandler<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends RoleAssignmentHelper {
    private final ClientLogger logger = new ClientLogger(((Object)((Object)this)).getClass());
    private WebAppBaseImpl<FluentT, FluentImplT> webAppBase;
    private List<String> creatableIdentityKeys;
    private Map<String, ManagedServiceIdentityUserAssignedIdentities> userAssignedIdentities;

    WebAppMsiHandler(AuthorizationManager authorizationManager, WebAppBaseImpl<FluentT, FluentImplT> webAppBase) {
        super(authorizationManager, webAppBase.taskGroup(), webAppBase.idProvider());
        this.webAppBase = webAppBase;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, ManagedServiceIdentityUserAssignedIdentities>();
    }

    WebAppMsiHandler<FluentT, FluentImplT> withLocalManagedServiceIdentity() {
        this.initSiteIdentity(ManagedServiceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    WebAppMsiHandler<FluentT, FluentImplT> withoutLocalManagedServiceIdentity() {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.innerModel());
        if (siteInner.identity() == null || siteInner.identity().type() == null || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.NONE) || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.USER_ASSIGNED)) {
            return this;
        }
        if (siteInner.identity().type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED)) {
            siteInner.identity().withType(ManagedServiceIdentityType.NONE);
        } else if (siteInner.identity().type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
            siteInner.identity().withType(ManagedServiceIdentityType.USER_ASSIGNED);
        }
        return this;
    }

    WebAppMsiHandler<FluentT, FluentImplT> withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initSiteIdentity(ManagedServiceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.webAppBase.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    WebAppMsiHandler<FluentT, FluentImplT> withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initSiteIdentity(ManagedServiceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new ManagedServiceIdentityUserAssignedIdentities());
        return this;
    }

    WebAppMsiHandler<FluentT, FluentImplT> withoutExternalManagedServiceIdentity(String identityId) {
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.webAppBase.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new ManagedServiceIdentityUserAssignedIdentities());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.innerModel());
        if (!this.userAssignedIdentities.isEmpty()) {
            siteInner.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    void handleExternalIdentities(SitePatchResourceInner siteUpdate) {
        if (this.handleRemoveAllExternalIdentitiesCase(siteUpdate)) {
            return;
        }
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.innerModel());
        ManagedServiceIdentity currentIdentity = siteInner.identity();
        siteUpdate.withIdentity(currentIdentity);
        if (!this.userAssignedIdentities.isEmpty()) {
            siteUpdate.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        } else if (currentIdentity != null) {
            currentIdentity.withUserAssignedIdentities(null);
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, ManagedServiceIdentityUserAssignedIdentities>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase(SitePatchResourceInner siteUpdate) {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.innerModel());
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (ManagedServiceIdentityUserAssignedIdentities v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                ManagedServiceIdentity currentIdentity = siteInner.identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase(Locale.ROOT));
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, ManagedServiceIdentityUserAssignedIdentities> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase(Locale.ROOT));
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        siteUpdate.withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.NONE));
                    } else if (currentIdentity.type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        siteUpdate.withIdentity(currentIdentity);
                        siteUpdate.identity().withType(ManagedServiceIdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals((Object)ManagedServiceIdentityType.USER_ASSIGNED)) {
                        siteUpdate.withIdentity(currentIdentity);
                        siteUpdate.identity().withType(ManagedServiceIdentityType.NONE);
                    }
                    siteUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.size() == 0 && removeIds.size() != 0 && currentIdentity == null) {
                    siteUpdate.withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.NONE));
                    siteUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
            }
        }
        return false;
    }

    private void initSiteIdentity(ManagedServiceIdentityType identityType) {
        if (!identityType.equals((Object)ManagedServiceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType)));
        }
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.innerModel());
        if (siteInner.identity() == null) {
            siteInner.withIdentity(new ManagedServiceIdentity());
        }
        if (siteInner.identity().type() == null || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.NONE) || siteInner.identity().type().equals((Object)identityType)) {
            siteInner.identity().withType(identityType);
        } else {
            siteInner.identity().withType(ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

