/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.ProvidersClient;
import com.azure.resourcemanager.appservice.fluent.models.ApplicationStackResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmOperationDescriptionInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.ApplicationStackCollection;
import com.azure.resourcemanager.appservice.models.CsmOperationCollection;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.ProviderOsTypeSelected;
import reactor.core.publisher.Mono;

public final class ProvidersClientImpl
implements ProvidersClient {
    private final ClientLogger logger = new ClientLogger(ProvidersClientImpl.class);
    private final ProvidersService service;
    private final WebSiteManagementClientImpl client;

    ProvidersClientImpl(WebSiteManagementClientImpl client) {
        this.service = (ProvidersService)RestProxy.create(ProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedFlux(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected, context), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedIterable(this.getAvailableStacksAsync(osTypeSelected, context));
    }

    @Override
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable(this.getAvailableStacksAsync(osTypeSelected));
    }

    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<CsmOperationDescriptionInner> listOperationsAsync() {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<CsmOperationDescriptionInner> listOperationsAsync(Context context) {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(context), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<CsmOperationDescriptionInner> listOperations() {
        return new PagedIterable(this.listOperationsAsync());
    }

    @Override
    public PagedIterable<CsmOperationDescriptionInner> listOperations(Context context) {
        return new PagedIterable(this.listOperationsAsync(context));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> listSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), osTypeSelected, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> listSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), osTypeSelected, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux(() -> this.listSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ApplicationStackResourceInner> listAsync() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux(() -> this.listSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(osTypeSelected, context), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ApplicationStackResourceInner> list(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedIterable(this.listAsync(osTypeSelected, context));
    }

    @Override
    public PagedIterable<ApplicationStackResourceInner> list() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable(this.listAsync(osTypeSelected));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAvailableStacksNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacksNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOperationsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksOnPremNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAvailableStacksOnPremNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksOnPremNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacksOnPremNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface ProvidersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacks(@HostParam(value="$host") String var1, @QueryParam(value="osTypeSelected") ProviderOsTypeSelected var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<CsmOperationCollection>> listOperations(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="osTypeSelected") ProviderOsTypeSelected var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacksNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<CsmOperationCollection>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacksOnPremNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

