/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.HostnameBinding;
import com.azure.resourcemanager.appservice.models.HostnameType;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

class HostnameBindingImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<HostnameBindingInner>
implements Creatable<HostnameBinding>,
HostnameBinding,
HostnameBinding.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
HostnameBinding.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final FluentImplT parent;
    private String domainName;
    private String name;

    HostnameBindingImpl(HostnameBindingInner innerObject, FluentImplT parent) {
        super((Object)innerObject);
        this.parent = parent;
        this.name = innerObject.name();
        if (this.name != null && this.name.contains("/")) {
            this.name = this.name.replace(parent.name() + "/", "");
        }
    }

    public String id() {
        return ((HostnameBindingInner)((Object)this.innerModel())).id();
    }

    public String type() {
        return ((HostnameBindingInner)((Object)this.innerModel())).type();
    }

    public String regionName() {
        return this.parent().regionName();
    }

    public Region region() {
        return this.parent().region();
    }

    public Map<String, String> tags() {
        return this.parent().tags();
    }

    @Override
    public String webAppName() {
        return ((HostnameBindingInner)((Object)this.innerModel())).siteName();
    }

    @Override
    public String domainId() {
        return ((HostnameBindingInner)((Object)this.innerModel())).domainId();
    }

    @Override
    public String azureResourceName() {
        return ((HostnameBindingInner)((Object)this.innerModel())).azureResourceName();
    }

    @Override
    public AzureResourceType azureResourceType() {
        return ((HostnameBindingInner)((Object)this.innerModel())).azureResourceType();
    }

    @Override
    public CustomHostnameDnsRecordType dnsRecordType() {
        return ((HostnameBindingInner)((Object)this.innerModel())).customHostnameDnsRecordType();
    }

    @Override
    public HostnameType hostnameType() {
        return ((HostnameBindingInner)((Object)this.innerModel())).hostnameType();
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent).withHostNameBinding(this);
        return this.parent;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withDnsRecordType(CustomHostnameDnsRecordType hostnameDnsRecordType) {
        Pattern pattern = Pattern.compile("([.\\w-]+|\\*)\\.([\\w-]+\\.\\w+)");
        Matcher matcher = pattern.matcher(this.name);
        if (hostnameDnsRecordType == CustomHostnameDnsRecordType.CNAME && !matcher.matches()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("root hostname cannot be assigned with a CName record"));
        }
        ((HostnameBindingInner)((Object)this.innerModel())).withCustomHostnameDnsRecordType(hostnameDnsRecordType);
        return this;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> refresh() {
        return this;
    }

    public Mono<HostnameBinding> refreshAsync() {
        HostnameBindingImpl self = this;
        Mono<HostnameBindingInner> observable = null;
        observable = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClient)((AppServiceManager)((Object)this.parent().manager())).serviceClient()).getWebApps().getHostnameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.parent().name(), this.name()) : ((WebSiteManagementClient)((AppServiceManager)((Object)this.parent().manager())).serviceClient()).getWebApps().getHostnameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name());
        return observable.map(hostnameBindingInner -> {
            self.setInner(hostnameBindingInner);
            return self;
        });
    }

    public HostnameBinding create() {
        return (HostnameBinding)this.createAsync().block();
    }

    public Mono<HostnameBinding> createAsync() {
        HostnameBindingImpl self = this;
        Function<HostnameBindingInner, HostnameBinding> mapper = hostnameBindingInner -> {
            this.setInner(hostnameBindingInner);
            return self;
        };
        Mono hostnameBindingObservable = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClient)((AppServiceManager)((Object)this.parent().manager())).serviceClient()).getWebApps().createOrUpdateHostnameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.name, this.parent().name(), (HostnameBindingInner)((Object)this.innerModel())).map(mapper) : ((WebSiteManagementClient)((AppServiceManager)((Object)this.parent().manager())).serviceClient()).getWebApps().createOrUpdateHostnameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name, (HostnameBindingInner)((Object)this.innerModel())).map(mapper);
        return hostnameBindingObservable;
    }

    private String normalizeHostNameBindingName(String hostname, String domainName) {
        if (!hostname.endsWith(domainName)) {
            hostname = hostname + "." + domainName;
        }
        if (hostname.startsWith("@")) {
            hostname = hostname.replace("@.", "");
        }
        return hostname;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withAzureManagedDomain(AppServiceDomain domain) {
        ((HostnameBindingInner)((Object)this.innerModel())).withDomainId(domain.id());
        ((HostnameBindingInner)((Object)this.innerModel())).withHostnameType(HostnameType.MANAGED);
        this.domainName = domain.name();
        return this;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withThirdPartyDomain(String domain) {
        ((HostnameBindingInner)((Object)this.innerModel())).withHostnameType(HostnameType.VERIFIED);
        this.domainName = domain;
        return this;
    }

    public String toString() {
        String suffix = this.azureResourceType() == AzureResourceType.TRAFFIC_MANAGER ? ".trafficmanager.net" : ".azurewebsites.net";
        return this.name + ": " + (Object)((Object)this.dnsRecordType()) + " " + this.azureResourceName() + suffix;
    }

    public String name() {
        return this.name;
    }

    public WebAppBase parent() {
        return this.parent;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withSubDomain(String subDomain) {
        this.name = this.normalizeHostNameBindingName(subDomain, this.domainName);
        return this;
    }
}

