/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ContainerInfo;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SiteRuntimeState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class WebSiteInstanceStatusInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebSiteInstanceStatusInner.class);
    @JsonProperty(value="properties.state")
    private SiteRuntimeState state;
    @JsonProperty(value="properties.statusUrl")
    private String statusUrl;
    @JsonProperty(value="properties.detectorUrl")
    private String detectorUrl;
    @JsonProperty(value="properties.consoleUrl")
    private String consoleUrl;
    @JsonProperty(value="properties.containers")
    private Map<String, ContainerInfo> containers;

    public SiteRuntimeState state() {
        return this.state;
    }

    public WebSiteInstanceStatusInner withState(SiteRuntimeState state) {
        this.state = state;
        return this;
    }

    public String statusUrl() {
        return this.statusUrl;
    }

    public WebSiteInstanceStatusInner withStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
        return this;
    }

    public String detectorUrl() {
        return this.detectorUrl;
    }

    public WebSiteInstanceStatusInner withDetectorUrl(String detectorUrl) {
        this.detectorUrl = detectorUrl;
        return this;
    }

    public String consoleUrl() {
        return this.consoleUrl;
    }

    public WebSiteInstanceStatusInner withConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
        return this;
    }

    public Map<String, ContainerInfo> containers() {
        return this.containers;
    }

    public WebSiteInstanceStatusInner withContainers(Map<String, ContainerInfo> containers) {
        this.containers = containers;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.containers() != null) {
            this.containers().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

