/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ArmIdWrapper;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class PrivateEndpointConnectionResourceInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionResourceInner.class);
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.privateEndpoint")
    private ArmIdWrapper privateEndpoint;
    @JsonProperty(value="properties.privateLinkServiceConnectionState")
    private PrivateLinkConnectionState privateLinkServiceConnectionState;

    public String provisioningState() {
        return this.provisioningState;
    }

    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionResourceInner withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionResourceInner withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }
}

