/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.CustomDomainsClient;
import com.azure.resourcemanager.appplatform.fluent.models.CustomDomainResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppDomainImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.CustomDomainProperties;
import com.azure.resourcemanager.appplatform.models.CustomDomainValidateResult;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDomain;
import com.azure.resourcemanager.appplatform.models.SpringAppDomains;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class SpringAppDomainsImpl
extends ExternalChildResourcesNonCachedImpl<SpringAppDomainImpl, SpringAppDomain, CustomDomainResourceInner, SpringAppImpl, SpringApp>
implements SpringAppDomains {
    SpringAppDomainsImpl(SpringAppImpl parent) {
        super((Object)parent, parent.taskGroup(), "SpringAppDomain");
    }

    public SpringAppDomain getById(String id) {
        return (SpringAppDomain)this.getByIdAsync(id).block();
    }

    public Mono<SpringAppDomain> getByIdAsync(String id) {
        return this.getByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public SpringAppDomain getByName(String name) {
        return (SpringAppDomain)this.getByNameAsync(name).block();
    }

    public Mono<SpringAppDomain> getByNameAsync(String name) {
        return this.inner().getAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name(), name).map(this::wrapModel);
    }

    SpringAppDomainImpl wrapModel(CustomDomainResourceInner inner) {
        return inner == null ? null : new SpringAppDomainImpl(inner.name(), this.parent(), inner);
    }

    public AppPlatformManager manager() {
        return this.parent().manager();
    }

    public SpringAppImpl parent() {
        return (SpringAppImpl)this.getParent();
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name(), name);
    }

    public PagedIterable<SpringAppDomain> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SpringAppDomain> listAsync() {
        return PagedConverter.mapPage(this.inner().listAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name()), this::wrapModel);
    }

    public CustomDomainsClient inner() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getCustomDomains();
    }

    @Override
    public CustomDomainValidateResult validate(String domain) {
        return (CustomDomainValidateResult)this.validateAsync(domain).block();
    }

    @Override
    public Mono<CustomDomainValidateResult> validateAsync(String domain) {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().validateDomainAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name(), domain);
    }

    SpringAppDomain prepareCreateOrUpdate(String name, CustomDomainProperties properties) {
        return (SpringAppDomain)this.prepareInlineDefine(new SpringAppDomainImpl(name, this.parent(), new CustomDomainResourceInner().withProperties(properties)));
    }

    void prepareDelete(String name) {
        this.prepareInlineRemove(new SpringAppDomainImpl(name, this.parent(), new CustomDomainResourceInner()));
    }
}

