/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.MonitoringSettingsClient;
import com.azure.resourcemanager.appplatform.fluent.models.MonitoringSettingResourceInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.MonitoringSettingProperties;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MonitoringSettingsClientImpl
implements MonitoringSettingsClient {
    private final ClientLogger logger = new ClientLogger(MonitoringSettingsClientImpl.class);
    private final MonitoringSettingsService service;
    private final AppPlatformManagementClientImpl client;

    MonitoringSettingsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (MonitoringSettingsService)RestProxy.create(MonitoringSettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MonitoringSettingResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MonitoringSettingResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MonitoringSettingResourceInner> getAsync(String resourceGroupName, String serviceName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MonitoringSettingResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner get(String resourceGroupName, String serviceName) {
        return (MonitoringSettingResourceInner)((Object)this.getAsync(resourceGroupName, serviceName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MonitoringSettingResourceInner> getWithResponse(String resourceGroupName, String serviceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        MonitoringSettingResourceInner monitoringSettingResource = new MonitoringSettingResourceInner();
        monitoringSettingResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, monitoringSettingResource, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        MonitoringSettingResourceInner monitoringSettingResource = new MonitoringSettingResourceInner();
        monitoringSettingResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, monitoringSettingResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MonitoringSettingResourceInner.class), (Type)((Object)MonitoringSettingResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MonitoringSettingResourceInner.class), (Type)((Object)MonitoringSettingResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MonitoringSettingResourceInner> updatePutAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MonitoringSettingResourceInner> updatePutAsync(String resourceGroupName, String serviceName) {
        MonitoringSettingProperties properties = null;
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MonitoringSettingResourceInner> updatePutAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePut(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return (MonitoringSettingResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePut(String resourceGroupName, String serviceName) {
        MonitoringSettingProperties properties = null;
        return (MonitoringSettingResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePut(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return (MonitoringSettingResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        MonitoringSettingResourceInner monitoringSettingResource = new MonitoringSettingResourceInner();
        monitoringSettingResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, monitoringSettingResource, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        MonitoringSettingResourceInner monitoringSettingResource = new MonitoringSettingResourceInner();
        monitoringSettingResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, monitoringSettingResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MonitoringSettingResourceInner.class), (Type)((Object)MonitoringSettingResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MonitoringSettingResourceInner.class), (Type)((Object)MonitoringSettingResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<MonitoringSettingResourceInner>, MonitoringSettingResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MonitoringSettingResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MonitoringSettingResourceInner> updatePatchAsync(String resourceGroupName, String serviceName) {
        MonitoringSettingProperties properties = null;
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MonitoringSettingResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePatch(String resourceGroupName, String serviceName, MonitoringSettingProperties properties) {
        return (MonitoringSettingResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePatch(String resourceGroupName, String serviceName) {
        MonitoringSettingProperties properties = null;
        return (MonitoringSettingResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MonitoringSettingResourceInner updatePatch(String resourceGroupName, String serviceName, MonitoringSettingProperties properties, Context context) {
        return (MonitoringSettingResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface MonitoringSettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/monitoringSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MonitoringSettingResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/monitoringSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePut(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") MonitoringSettingResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/monitoringSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePatch(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") MonitoringSettingResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

