/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.GitImplementation;
import java.io.IOException;
import java.util.List;

public final class ConfigurationServiceGitRepository
implements JsonSerializable<ConfigurationServiceGitRepository> {
    private String name;
    private List<String> patterns;
    private String uri;
    private String label;
    private List<String> searchPaths;
    private String username;
    private String password;
    private String hostKey;
    private String hostKeyAlgorithm;
    private String privateKey;
    private Boolean strictHostKeyChecking;
    private GitImplementation gitImplementation;
    private String caCertResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationServiceGitRepository.class);

    public String name() {
        return this.name;
    }

    public ConfigurationServiceGitRepository withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public ConfigurationServiceGitRepository withPatterns(List<String> patterns) {
        this.patterns = patterns;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ConfigurationServiceGitRepository withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String label() {
        return this.label;
    }

    public ConfigurationServiceGitRepository withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> searchPaths() {
        return this.searchPaths;
    }

    public ConfigurationServiceGitRepository withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ConfigurationServiceGitRepository withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ConfigurationServiceGitRepository withPassword(String password) {
        this.password = password;
        return this;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public ConfigurationServiceGitRepository withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public ConfigurationServiceGitRepository withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public ConfigurationServiceGitRepository withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public ConfigurationServiceGitRepository withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    public GitImplementation gitImplementation() {
        return this.gitImplementation;
    }

    public ConfigurationServiceGitRepository withGitImplementation(GitImplementation gitImplementation) {
        this.gitImplementation = gitImplementation;
        return this;
    }

    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    public ConfigurationServiceGitRepository withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ConfigurationServiceGitRepository"));
        }
        if (this.patterns() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property patterns in model ConfigurationServiceGitRepository"));
        }
        if (this.uri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property uri in model ConfigurationServiceGitRepository"));
        }
        if (this.label() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property label in model ConfigurationServiceGitRepository"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("patterns", this.patterns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("searchPaths", this.searchPaths, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("hostKey", this.hostKey);
        jsonWriter.writeStringField("hostKeyAlgorithm", this.hostKeyAlgorithm);
        jsonWriter.writeStringField("privateKey", this.privateKey);
        jsonWriter.writeBooleanField("strictHostKeyChecking", this.strictHostKeyChecking);
        jsonWriter.writeStringField("gitImplementation", this.gitImplementation == null ? null : this.gitImplementation.toString());
        jsonWriter.writeStringField("caCertResourceId", this.caCertResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationServiceGitRepository fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationServiceGitRepository)jsonReader.readObject(reader -> {
            ConfigurationServiceGitRepository deserializedConfigurationServiceGitRepository = new ConfigurationServiceGitRepository();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.name = reader.getString();
                    continue;
                }
                if ("patterns".equals(fieldName)) {
                    List patterns;
                    deserializedConfigurationServiceGitRepository.patterns = patterns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.uri = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.label = reader.getString();
                    continue;
                }
                if ("searchPaths".equals(fieldName)) {
                    List searchPaths;
                    deserializedConfigurationServiceGitRepository.searchPaths = searchPaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.password = reader.getString();
                    continue;
                }
                if ("hostKey".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.hostKey = reader.getString();
                    continue;
                }
                if ("hostKeyAlgorithm".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.hostKeyAlgorithm = reader.getString();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.privateKey = reader.getString();
                    continue;
                }
                if ("strictHostKeyChecking".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.strictHostKeyChecking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gitImplementation".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.gitImplementation = GitImplementation.fromString(reader.getString());
                    continue;
                }
                if ("caCertResourceId".equals(fieldName)) {
                    deserializedConfigurationServiceGitRepository.caCertResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationServiceGitRepository;
        });
    }
}

